/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.impl.movement;

import java.util.List;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.api.movement.PlayerState;
import tictim.paraglider.api.movement.StaminaReductionLogic;
import tictim.paraglider.impl.movement.StaminaReductionLogicLoader;

public final class StaminaReductionLogicHandler {
    private static boolean initialized;
    private static List<StaminaReductionLogic> logics;

    private StaminaReductionLogicHandler() {
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        logics = StaminaReductionLogicLoader.loadStaminaReductionLogics();
    }

    @NotNull
    public static @Unmodifiable List<StaminaReductionLogic> logics() {
        if (logics == null) {
            throw new IllegalStateException("Stamina reduction logic is not ready yet");
        }
        return logics;
    }

    public static double getReductionRate(@NotNull Player player, @NotNull PlayerState state) {
        if (state.staminaDelta() == 0) {
            return 0.0;
        }
        List<StaminaReductionLogic> logics = StaminaReductionLogicHandler.logics();
        boolean hasMatch = false;
        double reductionSum = 0.0;
        double min = Double.NaN;
        double max = Double.NaN;
        for (StaminaReductionLogic logic : logics) {
            if (!logic.isApplicable(player, state)) continue;
            hasMatch = true;
            double value = logic.getReductionRate(player, state);
            if (!Double.isNaN(value)) {
                reductionSum += value;
            }
            if (!Double.isNaN(value = logic.getMinReduction(player, state))) {
                double d = min = Double.isNaN(min) ? value : Math.min(min, value);
            }
            if (Double.isNaN(value = logic.getMaxReduction(player, state))) continue;
            max = Double.isNaN(max) ? value : Math.max(max, value);
        }
        if (!hasMatch) {
            return 0.0;
        }
        if (!Double.isNaN(max)) {
            reductionSum = Math.min(reductionSum, max);
        }
        if (!Double.isNaN(min)) {
            reductionSum = Math.max(reductionSum, min);
        }
        return reductionSum;
    }
}

