/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.util;

import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class RegistryHelper {
    private RegistryHelper() {
    }

    @Nullable
    public static <T> Registry<T> getRegistry(ResourceKey<? extends Registry<T>> key) {
        return (Registry)BuiltInRegistries.f_257047_.m_7745_(key.m_135782_());
    }

    public static <T> Stream<Holder<T>> getTagStream(Registry<T> registry, TagKey<T> key) {
        return StreamSupport.stream(registry.m_206058_(key).spliterator(), false);
    }

    public static <T> Stream<Holder<T>> getTagStream(TagKey<T> key) {
        Registry<T> registry = RegistryHelper.getRegistry(key.f_203867_());
        if (registry == null) {
            return Stream.empty();
        }
        return RegistryHelper.getTagStream(registry, key);
    }

    public static <T> Stream<T> getTagValueStream(Registry<T> registry, TagKey<T> key) {
        return RegistryHelper.getTagStream(registry, key).filter(Holder::m_203633_).map(Holder::m_203334_);
    }

    public static <T> Stream<T> getTagValueStream(TagKey<T> key) {
        return RegistryHelper.getTagStream(key).filter(Holder::m_203633_).map(Holder::m_203334_);
    }

    public static <T> boolean contains(Registry<T> registry, TagKey<T> tag, T value) {
        int index = registry.m_7447_(value);
        if (index == -1) {
            return false;
        }
        return registry.m_203300_(index).filter(holder -> holder.containsTag(tag)).isPresent();
    }

    public static <T> boolean contains(TagKey<T> tag, T value) {
        Registry<T> registry = RegistryHelper.getRegistry(tag.f_203867_());
        if (registry == null) {
            return false;
        }
        return RegistryHelper.contains(registry, tag, value);
    }

    public static boolean contains(TagKey<Block> tag, Block value) {
        return value.m_204297_().m_203656_(tag);
    }

    public static boolean contains(TagKey<Item> tag, Item value) {
        return value.m_204114_().m_203656_(tag);
    }

    public static boolean contains(TagKey<EntityType<?>> tag, EntityType<?> value) {
        return value.m_204041_().m_203656_(tag);
    }

    public static boolean contains(TagKey<Fluid> tag, Fluid value) {
        return value.m_205069_().m_203656_(tag);
    }

    public static <T> Supplier<T> getHolder(DefaultedRegistry<T> registry, T entry) {
        return (Supplier)registry.m_203300_(registry.m_7447_(entry)).orElseThrow();
    }
}

