/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.datamap;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import slimeknights.mantle.data.GenericDataProvider;
import slimeknights.mantle.data.datamap.BlockStateDataMapLoader;
import slimeknights.mantle.data.datamap.BlockStateDataMapProvider;
import slimeknights.mantle.data.datamap.StateVariantStringBuilder;
import slimeknights.mantle.data.loadable.Loadable;

public abstract class BlockStateDataMapProvider<D>
extends GenericDataProvider {
    private final Loadable<D> dataLoader;
    private final String modId;
    private final Map<Block, DataMap> blocks = new HashMap<Block, DataMap>();
    private final Map<ResourceLocation, D> entries = new HashMap<ResourceLocation, D>();

    public BlockStateDataMapProvider(PackOutput output, PackOutput.Target type, String folder, Loadable<D> dataLoader, String modId) {
        super(output, type, folder);
        this.dataLoader = dataLoader;
        this.modId = modId;
    }

    public BlockStateDataMapProvider(PackOutput output, PackOutput.Target type, BlockStateDataMapLoader<D> registry, String modId) {
        this(output, type, registry.getFolder(), registry.getDataLoader(), modId);
    }

    protected abstract void addEntries();

    public CompletableFuture<?> m_213708_(CachedOutput cached) {
        this.addEntries();
        return BlockStateDataMapProvider.allOf(Stream.concat(this.blocks.values().stream().map(entry -> this.saveJson(cached, BuiltInRegistries.f_256975_.m_7981_((Object)entry.owner), entry.toJson())), this.entries.entrySet().stream().map(entry -> this.saveJson(cached, (ResourceLocation)entry.getKey(), this.dataLoader.serialize(entry.getValue())))));
    }

    protected DataMap block(Block block) {
        return this.blocks.computeIfAbsent(block, x$0 -> new DataMap((Block)x$0));
    }

    protected DataMap block(Supplier<? extends Block> block) {
        return this.block(block.get());
    }

    protected void entry(ResourceLocation key, D data) {
        D original = this.entries.putIfAbsent(key, data);
        if (original != null) {
            throw new IllegalArgumentException("Duplicate entry at " + key + ", original " + original + ", new value " + data);
        }
    }

    protected void entry(String key, D data) {
        this.entry(new ResourceLocation(this.modId, key), data);
    }

    protected class DataMap {
        private final Block owner;
        private final List<Variant<D>> variants = new ArrayList();

        public slimeknights.mantle.data.datamap.BlockStateDataMapProvider$DataMap.VariantBuilder variant(D data) {
            VariantBuilder builder = new VariantBuilder();
            this.variants.add(new Variant(data, null, builder));
            return builder;
        }

        public slimeknights.mantle.data.datamap.BlockStateDataMapProvider$DataMap.VariantBuilder variant(ResourceLocation parent) {
            VariantBuilder builder = new VariantBuilder();
            this.variants.add(new Variant<Object>(null, parent, builder));
            return builder;
        }

        public slimeknights.mantle.data.datamap.BlockStateDataMapProvider$DataMap.VariantBuilder variant(String parent) {
            return this.variant(new ResourceLocation(BlockStateDataMapProvider.this.modId, parent));
        }

        private JsonObject toJson() {
            JsonObject variants = new JsonObject();
            for (Variant variant : this.variants) {
                String variantString = variant.variant.toString();
                if (variant.data != null) {
                    variants.add(variantString, BlockStateDataMapProvider.this.dataLoader.serialize(variant.data));
                    continue;
                }
                if (variant.parent == null) continue;
                variants.addProperty(variantString, variant.parent.toString());
            }
            JsonObject map = new JsonObject();
            map.add("variants", (JsonElement)variants);
            return map;
        }

        private DataMap(Block owner) {
            this.owner = owner;
        }

        public class VariantBuilder
        extends StateVariantStringBuilder {
            protected VariantBuilder() {
                super(DataMap.this.owner);
            }

            public DataMap end() {
                return DataMap.this;
            }
        }
    }

    private record Variant<D>(@Nullable D data, @Nullable ResourceLocation parent, StateVariantStringBuilder variant) {
    }
}

