/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import com.google.common.collect.Lists;
import java.util.List;
import net.blay09.mods.balm.api.block.entity.CustomRenderBoundingBox;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.capability.DefaultKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.CounterBlock;
import net.blay09.mods.cookingforblockheads.menu.CounterMenu;
import net.blay09.mods.cookingforblockheads.tile.IMutableNameable;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.tile.util.DoorAnimator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class CounterBlockEntity
extends BalmBlockEntity
implements BalmMenuProvider,
IMutableNameable,
BalmContainerProvider,
CustomRenderBoundingBox {
    private final int containerSize;
    private final DefaultContainer container;
    private final DefaultKitchenItemProvider itemProvider;
    private final DoorAnimator doorAnimator;
    private Component customName;
    private boolean isDirty;
    private DyeColor color;

    public CounterBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.counter.get(), pos, state);
    }

    public CounterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.containerSize = CookingForBlockheadsConfig.getActive().largeCounters ? 54 : 27;
        this.container = new DefaultContainer(this.containerSize){

            public void m_6596_() {
                CounterBlockEntity.this.isDirty = true;
                CounterBlockEntity.this.m_6596_();
            }
        };
        this.itemProvider = new DefaultKitchenItemProvider((Container)this.container);
        this.doorAnimator = new DoorAnimator((BlockEntity)this, 1, 2);
        this.color = DyeColor.WHITE;
        this.doorAnimator.setOpenRadius(2.0f);
        this.doorAnimator.setSoundEventOpen(SoundEvents.f_11749_);
        this.doorAnimator.setSoundEventClose(SoundEvents.f_11747_);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, CounterBlockEntity blockEntity) {
        blockEntity.clientTick(level, pos, state);
    }

    public void clientTick(Level level, BlockPos pos, BlockState state) {
        this.doorAnimator.update();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CounterBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
    }

    public boolean m_7531_(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.m_7531_(id, type);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        CompoundTag itemHandlerCompound = tag.m_128469_("ItemHandler");
        if (CookingForBlockheadsConfig.getActive().largeCounters && itemHandlerCompound.m_128451_("Size") < 54) {
            itemHandlerCompound.m_128405_("Size", 54);
        }
        this.container.deserialize(itemHandlerCompound);
        this.color = DyeColor.m_41053_((int)tag.m_128445_("Color"));
        if (tag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
        if (tag.m_128425_("IsForcedOpen", 1)) {
            this.doorAnimator.setForcedOpen(tag.m_128471_("IsForcedOpen"));
        }
        if (tag.m_128425_("NumPlayersUsing", 1)) {
            this.doorAnimator.setNumPlayersUsing(tag.m_128445_("NumPlayersUsing"));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("ItemHandler", (Tag)this.container.serialize());
        tag.m_128344_("Color", (byte)this.color.m_41060_());
        if (this.customName != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    public void writeUpdateTag(CompoundTag tag) {
        this.m_183515_(tag);
        tag.m_128379_("IsForcedOpen", this.doorAnimator.isForcedOpen());
        tag.m_128344_("NumPlayersUsing", (byte)this.doorAnimator.getNumPlayersUsing());
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(IKitchenItemProvider.class, (Object)this.itemProvider)});
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    public Direction getFacing() {
        BlockState blockState = this.m_58900_();
        return blockState.m_61138_((Property)BlockStateProperties.f_61372_) ? (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_) : Direction.NORTH;
    }

    public boolean isFlipped() {
        BlockState blockState = this.m_58900_();
        return blockState.m_61138_((Property)CounterBlock.FLIPPED) && (Boolean)blockState.m_61143_((Property)CounterBlock.FLIPPED) != false;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new CounterMenu(i, playerInventory, this);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(-1, 0, -1), this.f_58858_.m_7918_(2, 1, 2));
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public void setCustomName(Component customName) {
        this.customName = customName;
        this.m_6596_();
    }

    public boolean m_8077_() {
        return this.customName != null;
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Override
    public Component getDefaultName() {
        return Component.m_237115_((String)"container.cookingforblockheads.counter");
    }

    public void m_6596_() {
        this.isDirty = true;
        super.m_6596_();
    }

    public Container getContainer() {
        return this.container;
    }
}

