/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.block.BlockDyeableKitchen;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.tile.CounterBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CounterBlock
extends BlockDyeableKitchen {
    public static final String name = "counter";
    public static final ResourceLocation registryName = new ResourceLocation("cookingforblockheads", "counter");

    public CounterBlock() {
        this(registryName);
    }

    public CounterBlock(ResourceLocation registryName) {
        super(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56742_).m_60913_(5.0f, 10.0f), registryName);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, FLIPPED, COLOR, HAS_COLOR});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CounterBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        ItemStack heldItem = player.m_21120_(hand);
        if (this.tryRecolorBlock(state, heldItem, level, pos, player, rayTraceResult)) {
            return InteractionResult.SUCCESS;
        }
        CounterBlockEntity counter = (CounterBlockEntity)level.m_7702_(pos);
        if (rayTraceResult.m_82434_() == state.m_61143_((Property)FACING) && counter != null) {
            if (player.m_6144_()) {
                counter.getDoorAnimator().toggleForcedOpen();
                return InteractionResult.SUCCESS;
            }
            if (!heldItem.m_41619_() && counter.getDoorAnimator().isForcedOpen()) {
                heldItem = counter.insertItemStacked(heldItem, false);
                player.m_21008_(hand, heldItem);
                return InteractionResult.SUCCESS;
            }
        }
        if (!level.f_46443_) {
            if (rayTraceResult.m_82434_() == Direction.UP && !heldItem.m_41619_() && (heldItem.m_41720_() instanceof BlockItem || heldItem.m_41720_() == Compat.cuttingBoardItem)) {
                return InteractionResult.FAIL;
            }
            Balm.getNetworking().openGui(player, (MenuProvider)counter);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return (BlockState)state.m_61124_((Property)FLIPPED, (Comparable)Boolean.valueOf(this.shouldBePlacedFlipped(context, (Direction)state.m_61143_((Property)FACING))));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? CounterBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.counter.get()), CounterBlockEntity::clientTick) : CounterBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.counter.get()), CounterBlockEntity::serverTick);
    }
}

