/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.compat.configured;

import com.anthonyhilyard.iceberg.Loader;
import com.anthonyhilyard.iceberg.compat.configured.IcebergFolderEntry;
import com.anthonyhilyard.iceberg.config.IcebergConfigSpec;
import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IModConfig;
import com.mrcrayfish.configured.impl.forge.ForgeListValue;
import com.mrcrayfish.configured.impl.forge.ForgeValue;
import com.mrcrayfish.configured.util.ConfigHelper;
import com.mrcrayfish.configured.util.ForgeConfigHelper;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.compress.utils.Lists;

public class IcebergConfigPlugin
implements IModConfig {
    protected static final EnumMap<ModConfig.Type, ConfigType> TYPE_RESOLVER = (EnumMap)Util.m_137469_(new EnumMap(ModConfig.Type.class), map -> {
        map.put(ModConfig.Type.CLIENT, ConfigType.CLIENT);
        map.put(ModConfig.Type.COMMON, ConfigType.UNIVERSAL);
        map.put(ModConfig.Type.SERVER, ConfigType.WORLD_SYNC);
    });
    protected final ModConfig config;
    protected final List<IcebergValueEntry> allConfigValues;

    public IcebergConfigPlugin(ModConfig config) {
        this.config = config;
        this.allConfigValues = IcebergConfigPlugin.getAllConfigValues(config);
    }

    public void update(IConfigEntry entry) {
        Set changedValues = ConfigHelper.getChangedValues((IConfigEntry)entry);
        if (!changedValues.isEmpty()) {
            CommentedConfig newConfig = CommentedConfig.copy((UnmodifiableCommentedConfig)this.config.getConfigData());
            changedValues.forEach(value -> {
                if (value instanceof ForgeValue) {
                    ForgeListValue forgeList;
                    List converted;
                    ForgeValue forge = (ForgeValue)value;
                    if (forge instanceof ForgeListValue && (converted = (forgeList = (ForgeListValue)forge).getConverted()) != null) {
                        newConfig.set(forge.configValue.getPath(), (Object)converted);
                        return;
                    }
                    newConfig.set(forge.configValue.getPath(), value.get());
                }
            });
            this.config.getConfigData().putAll((UnmodifiableConfig)newConfig);
        }
        if (this.getType() == ConfigType.WORLD_SYNC) {
            if (!ConfigHelper.isPlayingGame()) {
                this.config.getHandler().unload(this.config.getFullPath().getParent(), this.config);
                ForgeConfigHelper.setForgeConfigData((ModConfig)this.config, null);
            }
        } else if (!changedValues.isEmpty()) {
            Loader.LOGGER.info("Sending config reloading event for {}", (Object)this.config.getFileName());
            this.config.getSpec().afterReload();
            ForgeConfigHelper.fireForgeConfigEvent((ModConfig)this.config, (ModConfigEvent)new ModConfigEvent.Reloading(this.config));
        }
    }

    public IConfigEntry getRoot() {
        return new IcebergFolderEntry(((IcebergConfigSpec)this.config.getSpec()).getValues(), (IcebergConfigSpec)this.config.getSpec());
    }

    public ConfigType getType() {
        return TYPE_RESOLVER.get(this.config.getType());
    }

    public String getFileName() {
        return this.config.getFileName();
    }

    public String getModId() {
        return this.config.getModId();
    }

    public void loadWorldConfig(Path path, Consumer<IModConfig> result) {
        CommentedFileConfig data = (CommentedFileConfig)this.config.getHandler().reader(path).apply(this.config);
        ForgeConfigHelper.setForgeConfigData((ModConfig)this.config, (CommentedConfig)data);
        result.accept(this);
    }

    public void stopEditing() {
        if (this.config != null && this.getType() == ConfigType.WORLD && !ConfigHelper.isPlayingGame()) {
            this.config.getHandler().unload(this.config.getFullPath().getParent(), this.config);
            ForgeConfigHelper.setForgeConfigData((ModConfig)this.config, null);
        }
    }

    public boolean isChanged() {
        if (ConfigHelper.isWorldConfig((IModConfig)this) && this.config.getConfigData() == null) {
            return false;
        }
        return this.allConfigValues.stream().anyMatch(entry -> !Objects.equals(entry.value.get(), entry.spec.getDefault()));
    }

    public void restoreDefaults() {
        if (ConfigHelper.isWorldConfig((IModConfig)this) && this.config.getConfigData() == null) {
            return;
        }
        CommentedConfig newConfig = CommentedConfig.copy((UnmodifiableCommentedConfig)this.config.getConfigData());
        this.allConfigValues.forEach(entry -> newConfig.set(entry.value.getPath(), entry.spec.getDefault()));
        this.config.getConfigData().putAll((UnmodifiableConfig)newConfig);
        this.allConfigValues.forEach(pair -> pair.value.clearCache());
    }

    private static List<IcebergValueEntry> getAllConfigValues(ModConfig config) {
        IcebergConfigSpec icebergConfigSpec = (IcebergConfigSpec)config.getSpec();
        ArrayList values = Lists.newArrayList();
        IcebergConfigPlugin.gatherValuesFromIcebergConfig(icebergConfigSpec.getValues(), icebergConfigSpec, values);
        return ImmutableList.copyOf((Collection)values).stream().map(pair -> new IcebergValueEntry((ForgeConfigSpec.ConfigValue)pair.getFirst(), (ForgeConfigSpec.ValueSpec)pair.getSecond())).collect(Collectors.toList());
    }

    private static void gatherValuesFromIcebergConfig(UnmodifiableConfig config, IcebergConfigSpec spec, List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> values) {
        config.valueMap().forEach((key, value) -> {
            if (value instanceof AbstractConfig) {
                IcebergConfigPlugin.gatherValuesFromIcebergConfig((UnmodifiableConfig)value, spec, values);
            } else if (value instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)value;
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)spec.getRaw(configValue.getPath());
                values.add(Pair.of((Object)configValue, (Object)valueSpec));
            }
        });
    }

    private record IcebergValueEntry(ForgeConfigSpec.ConfigValue<?> value, ForgeConfigSpec.ValueSpec spec) {
    }
}

