/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.enhanced_mushrooms.core;

import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import com.teamaurora.enhanced_mushrooms.core.data.client.EMBlockStateProvider;
import com.teamaurora.enhanced_mushrooms.core.data.client.EMItemModelProvider;
import com.teamaurora.enhanced_mushrooms.core.data.server.EMLootTableProvider;
import com.teamaurora.enhanced_mushrooms.core.data.server.EMRecipeProvider;
import com.teamaurora.enhanced_mushrooms.core.data.server.tags.EMBlockTagsProvider;
import com.teamaurora.enhanced_mushrooms.core.data.server.tags.EMItemTagsProvider;
import com.teamaurora.enhanced_mushrooms.core.other.EMClientCompat;
import com.teamaurora.enhanced_mushrooms.core.other.EMCompat;
import com.teamaurora.enhanced_mushrooms.core.registry.EMBlocks;
import com.teamaurora.enhanced_mushrooms.core.registry.EMItems;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="enhanced_mushrooms")
public class EnhancedMushrooms {
    public static final String MOD_ID = "enhanced_mushrooms";
    public static final Logger LOGGER = LogManager.getLogger((String)"enhanced_mushrooms");
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("enhanced_mushrooms");
    public static final RegistryHelper VANILLA_HELPER = new RegistryHelper("minecraft");

    public EnhancedMushrooms() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        REGISTRY_HELPER.register(bus);
        VANILLA_HELPER.register(bus);
        bus.addListener(this::commonSetup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::dataSetup);
        bus.addListener(EventPriority.LOWEST, this::buildCreativeModeTabContents);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            EMBlocks.setupTabEditors();
            EMItems.setupTabEditors();
        });
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> EMCompat.registerCompat());
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> EMClientCompat.registerRenderLayers());
    }

    private void dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean includeServer = event.includeServer();
        EMBlockTagsProvider blockTags = new EMBlockTagsProvider(output, provider, helper);
        generator.addProvider(includeServer, (DataProvider)blockTags);
        generator.addProvider(includeServer, (DataProvider)new EMItemTagsProvider(output, provider, blockTags.m_274426_(), helper));
        generator.addProvider(includeServer, (DataProvider)new EMRecipeProvider(output));
        generator.addProvider(includeServer, (DataProvider)new EMLootTableProvider(output));
        boolean includeClient = event.includeClient();
        generator.addProvider(includeClient, (DataProvider)new EMBlockStateProvider(output, helper));
        generator.addProvider(includeClient, (DataProvider)new EMItemModelProvider(output, helper));
    }

    @SubscribeEvent
    public void buildCreativeModeTabContents(@NotNull BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256776_) {
            MutableHashedLinkedMap entries = event.getEntries();
            ArrayList<ItemStack> mushroom_stems = new ArrayList<ItemStack>();
            for (Map.Entry entry : entries) {
                if (!((ItemStack)entry.getKey()).m_150930_(Items.f_42024_)) continue;
                LOGGER.info(entry.getKey());
            }
            mushroom_stems.forEach(arg_0 -> ((MutableHashedLinkedMap)entries).remove(arg_0));
        }
    }
}

