/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.util;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class EntityUtil {
    public static final SpawnPlacements.Type MONOLITH_SPAWNING_CONDITION = SpawnPlacements.Type.create((String)"any_with_solid_under", (levelReader, blockPos, entityType) -> SpawnPlacements.Type.ON_GROUND.canSpawnAt(levelReader, blockPos, entityType) || levelReader.m_6425_(blockPos).m_192917_((Fluid)Fluids.f_76193_));

    public static boolean isNotAPetOf(Entity owner, LivingEntity target) {
        OwnableEntity ownable;
        if (target instanceof OwnableEntity && (ownable = (OwnableEntity)target).m_269323_() == owner) {
            return false;
        }
        return !target.m_21224_() && !target.m_213877_();
    }

    private static <T extends LivingEntity> boolean isValidTargetForOwnableBase(T pet, LivingEntity potentialTarget) {
        if (potentialTarget == pet) {
            return false;
        }
        if (((OwnableEntity)pet).m_269323_() != null) {
            if (((OwnableEntity)pet).m_269323_() == potentialTarget) {
                return false;
            }
            if (potentialTarget instanceof OwnableEntity) {
                OwnableEntity ownable = (OwnableEntity)potentialTarget;
                if (((OwnableEntity)pet).m_269323_() == ownable.m_269323_()) {
                    return false;
                }
            }
        }
        return !potentialTarget.m_21224_() && !potentialTarget.m_213877_();
    }

    public static <T extends LivingEntity> boolean isValidTargetForOwnable(T pet, LivingEntity potentialTarget) {
        return EntityUtil.isValidTargetForOwnableBase(pet, potentialTarget) && TargetingConditions.m_148352_().m_26885_(pet, potentialTarget);
    }

    public static <T extends LivingEntity> TargetingConditions isValidTargetForOwnableCondition(T pet) {
        return TargetingConditions.m_148352_().m_26888_(target -> EntityUtil.isValidTargetForOwnableBase(pet, target));
    }
}

