/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.mixin;

import com.aqutheseal.celestisynth.api.item.CSWeapon;
import com.aqutheseal.celestisynth.api.mixin.PlayerMixinSupport;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements PlayerMixinSupport {
    private static final String SCREENSHAKE_DURATION = "cs.screenShakeDuration";
    private static final String SCREENSHAKE_FADEOUTBEGIN = "cs.screenShakeFadeoutStart";
    private static final String SCREENSHAKE_INTENSITY = "cs.screenShakeIntensity";
    private static final String PULSE_SCALE = "cs.pulseScale";
    private static final String PULSE_TIME_SPEED = "cs.pulseTimeSpeed";
    private static final String CHANT_MESSAGE = "cs.chantMessage";
    private static final String CHANT_TIME = "cs.chantTime";
    private static final String CHANT_COLOR = "cs.chantColor";
    private static final String KERES_TIME = "cs.keresTime";
    private static final String KERES_IMAGE = "cs.keresImage";

    private PlayerMixin(EntityType<? extends LivingEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Shadow
    public abstract Inventory m_150109_();

    @Inject(method={"attack"}, at={@At(value="HEAD")}, cancellable=true)
    public void celestisynth$attack(Entity pTarget, CallbackInfo ci) {
        if (this.cancelCI(this.m_21205_()) || this.cancelCI(this.m_21206_())) {
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void celestisynth$tick(CallbackInfo ci) {
        if (this.m_9236_().m_5776_()) {
            if (this.getScreenShakeDuration() > 0) {
                if (this.getScreenShakeIntensity() > 1.0f) {
                    this.setScreenShakeIntensity(1.0f);
                }
                this.setScreenShakeDuration(this.getScreenShakeDuration() - 1);
                if (this.getScreenShakeDuration() < this.getScreenShakeFadeoutBegin()) {
                    this.setScreenShakeIntensity(Math.max(0.0f, this.getScreenShakeIntensity() - 0.001f));
                }
            }
            if (this.getPulseScale() > 0) {
                this.setPulseScale(Math.max(0, this.getPulseScale() - this.getPulseTimeSpeed()));
            }
            if (this.getChantMark() < 20) {
                this.setChantMark(Math.min(this.getChantMark() + 1, 20));
            }
            if (this.getTexturePulseMark() < 20) {
                this.setTexturePulseMark(Math.min(this.getTexturePulseMark() + 1, 20));
            }
        }
    }

    @Override
    public String getChantMessage() {
        return this.getPersistentData().m_128461_(CHANT_MESSAGE);
    }

    @Override
    public void setChantMessage(String message) {
        this.getPersistentData().m_128359_(CHANT_MESSAGE, message);
    }

    @Override
    public int getChantMark() {
        return this.getPersistentData().m_128451_(CHANT_TIME);
    }

    @Override
    public void setChantMark(int time) {
        this.getPersistentData().m_128405_(CHANT_TIME, time);
    }

    @Override
    public int getChantColor() {
        return this.getPersistentData().m_128451_(CHANT_COLOR);
    }

    @Override
    public void setChantColor(int color) {
        this.getPersistentData().m_128405_(CHANT_COLOR, color);
    }

    @Override
    public int getTexturePulseMark() {
        return this.getPersistentData().m_128451_(KERES_TIME);
    }

    @Override
    public void setTexturePulseMark(int time) {
        this.getPersistentData().m_128405_(KERES_TIME, time);
    }

    @Override
    public String getTexturePulseImage() {
        return this.getPersistentData().m_128461_(KERES_IMAGE);
    }

    @Override
    public void setTexturePulseImage(String order) {
        this.getPersistentData().m_128359_(KERES_IMAGE, order);
    }

    @Override
    public int getPulseScale() {
        return this.getPersistentData().m_128451_(PULSE_SCALE);
    }

    @Override
    public void setPulseScale(int scale) {
        this.getPersistentData().m_128405_(PULSE_SCALE, scale);
    }

    @Override
    public int getPulseTimeSpeed() {
        return this.getPersistentData().m_128451_(PULSE_TIME_SPEED);
    }

    @Override
    public void setPulseTimeSpeed(int speed) {
        this.getPersistentData().m_128405_(PULSE_TIME_SPEED, speed);
    }

    @Override
    public int getScreenShakeDuration() {
        return this.getPersistentData().m_128451_(SCREENSHAKE_DURATION);
    }

    @Override
    public void setScreenShakeDuration(int duration) {
        this.getPersistentData().m_128405_(SCREENSHAKE_DURATION, duration);
    }

    @Override
    public int getScreenShakeFadeoutBegin() {
        return this.getPersistentData().m_128451_(SCREENSHAKE_FADEOUTBEGIN);
    }

    @Override
    public void setScreenShakeFadeoutBegin(int beginByValue) {
        this.getPersistentData().m_128405_(SCREENSHAKE_FADEOUTBEGIN, beginByValue);
    }

    @Override
    public float getScreenShakeIntensity() {
        return this.getPersistentData().m_128457_(SCREENSHAKE_INTENSITY);
    }

    @Override
    public void setScreenShakeIntensity(float intensity) {
        this.getPersistentData().m_128350_(SCREENSHAKE_INTENSITY, intensity);
    }

    private boolean cancelCI(ItemStack stack) {
        CompoundTag controllerTag;
        if (stack.m_41720_() instanceof CSWeapon && (controllerTag = stack.m_41737_("csController")) != null) {
            return controllerTag.m_128471_("cs.hasAnimationBegun");
        }
        return false;
    }
}

