/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.mixin;

import com.aqutheseal.celestisynth.api.item.CSGeoItem;
import com.aqutheseal.celestisynth.common.capabilities.CSItemStackCapabilityProvider;
import com.aqutheseal.celestisynth.util.SkinUtil;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Item.class})
public abstract class ItemMixin {
    @Inject(method={"inventoryTick"}, at={@At(value="HEAD")})
    public void inventoryTick(ItemStack itemStack, Level level, Entity entity, int itemSlot, boolean isSelected, CallbackInfo ci) {
        itemStack.getCapability(CSItemStackCapabilityProvider.CAPABILITY).ifPresent(data -> {
            if (SkinUtil.getAquaSkinWhitelist().contains(entity.m_20148_())) {
                data.setSkinIndex(1);
            } else {
                data.setSkinIndex(0);
            }
        });
    }

    @Inject(method={"initializeClient"}, at={@At(value="TAIL")}, remap=false)
    public void initializeClient(Consumer<IClientItemExtensions> consumer, CallbackInfo ci) {
        ItemMixin itemMixin = this;
        if (itemMixin instanceof CSGeoItem) {
            CSGeoItem geoItem = (CSGeoItem)((Object)itemMixin);
            geoItem.initGeo(consumer);
        }
    }
}

