/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.mixin;

import com.aqutheseal.celestisynth.common.capabilities.CSEntityCapabilityProvider;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.commands.CommandSource;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.extensions.IForgeEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
extends CapabilityProvider<Entity>
implements Nameable,
EntityAccess,
CommandSource,
IForgeEntity {
    protected EntityMixin(Class<Entity> baseClass) {
        super(baseClass);
    }

    @Inject(method={"isInvisible"}, at={@At(value="HEAD")}, cancellable=true)
    public void isInvisible(CallbackInfoReturnable<Boolean> cir) {
        Entity entity = this.celestisynth$thisEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            AtomicBoolean flag = new AtomicBoolean(false);
            CSEntityCapabilityProvider.get(living).ifPresent(data -> flag.set(data.getTrueInvisibility() > 0));
            if (flag.get()) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"isInvisibleTo"}, at={@At(value="HEAD")}, cancellable=true)
    public void isInvisibleTo(Player pPlayer, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = this.celestisynth$thisEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            AtomicBoolean flag = new AtomicBoolean(false);
            CSEntityCapabilityProvider.get(living).ifPresent(data -> flag.set(data.getTrueInvisibility() > 0));
            if (flag.get()) {
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Unique
    public Entity celestisynth$thisEntity() {
        return (Entity)this;
    }
}

