/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.datagen.providers;

import com.aqutheseal.celestisynth.Celestisynth;
import com.aqutheseal.celestisynth.common.registry.CSBlocks;
import com.aqutheseal.celestisynth.common.registry.CSItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class CSItemModelProvider
extends ItemModelProvider {
    private static final List<RegistryObject<Item>> exemptions = new ArrayList<RegistryObject<Item>>();

    public CSItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "celestisynth", existingFileHelper);
    }

    protected void registerModels() {
        exemptions.add(CSItems.SOLARIS);
        exemptions.add(CSItems.CRESCENTIA);
        exemptions.add(CSItems.BREEZEBREAKER);
        exemptions.add(CSItems.POLTERGEIST);
        exemptions.add(CSItems.AQUAFLORA);
        exemptions.add(CSItems.RAINFALL_SERENITY);
        exemptions.add(CSItems.FROSTBOUND);
        exemptions.add(CSItems.TRAVERSER_SPAWN_EGG);
        exemptions.add(CSItems.TEMPEST_SPAWN_EGG);
        this.defaultItem(CSItems.ITEMS.getEntries());
        this.defaultItem(CSItems.SOLAR_CRYSTAL_HELMET);
        this.defaultItem(CSItems.SOLAR_CRYSTAL_CHESTPLATE);
        this.defaultItem(CSItems.SOLAR_CRYSTAL_LEGGINGS);
        this.defaultItem(CSItems.SOLAR_CRYSTAL_BOOTS);
        this.defaultItem(CSItems.LUNAR_STONE_HELMET);
        this.defaultItem(CSItems.LUNAR_STONE_CHESTPLATE);
        this.defaultItem(CSItems.LUNAR_STONE_LEGGINGS);
        this.defaultItem(CSItems.LUNAR_STONE_BOOTS);
        this.spawnEgg(CSItems.TRAVERSER_SPAWN_EGG);
        this.csCustomModel(((Block)CSBlocks.SOLAR_CRYSTAL.get()).m_5456_(), this.getMcLoc("item/generated"));
        this.block(CSBlocks.LUNAR_STONE);
        this.block(CSBlocks.ZEPHYR_DEPOSIT);
        this.block(CSBlocks.WINTEREIS);
        this.csCustomModel((Item)CSItems.CELESTIAL_DEBUGGER.get(), this.getMcLoc("item/handheld"));
    }

    public void defaultItem(Collection<RegistryObject<Item>> items) {
        for (RegistryObject<Item> item : items) {
            ModelFile.ExistingModelFile modelType;
            if (exemptions.contains(item)) {
                return;
            }
            String name = item.getId().m_135815_();
            Item getItem = (Item)item.get();
            ResourceLocation datagenLoc = Celestisynth.prefix("item/" + name);
            ModelFile.ExistingModelFile existingModelFile = modelType = getItem instanceof DiggerItem || getItem instanceof SwordItem ? this.getMcLoc("item/handheld") : this.getMcLoc("item/generated");
            if (getItem instanceof BlockItem) {
                return;
            }
            if (!this.existingFileHelper.exists(datagenLoc, (ExistingFileHelper.IResourceType)TEXTURE) && this.existingFileHelper.exists(datagenLoc, (ExistingFileHelper.IResourceType)MODEL)) continue;
            ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)modelType)).texture("layer0", "item/" + name);
        }
    }

    public void defaultItem(RegistryObject<Item> item) {
        String name = item.getId().m_135815_();
        Item getItem = (Item)item.get();
        ModelFile.ExistingModelFile modelType = getItem instanceof DiggerItem || getItem instanceof SwordItem ? this.getMcLoc("item/handheld") : this.getMcLoc("item/generated");
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)modelType)).texture("layer0", "item/" + name);
    }

    public void spawnEgg(RegistryObject<Item> item) {
        String name = item.getId().m_135815_();
        Item getItem = (Item)item.get();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)this.getMcLoc("item/template_spawn_egg"));
    }

    public void block(RegistryObject<Block> blockItem) {
        String name = blockItem.getId().m_135815_();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)this.getCSLoc("block/" + name));
    }

    public void csCustomModel(RegistryObject<Item> item, ModelFile.ExistingModelFile modelPath) {
        this.csCustomModel((Item)item.get(), modelPath);
    }

    public void csCustomModel(Item item, ModelFile.ExistingModelFile modelType) {
        String name = ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)modelType)).texture("layer0", "item/" + name);
    }

    public void csSinglePredicatedModel(RegistryObject<Item> item, String modelPath, ResourceLocation predicate, String predicatedModelPath) {
        String name = item.getId().m_135815_();
        ModelFile.ExistingModelFile modelType = this.getCSLoc(modelPath);
        ModelFile.ExistingModelFile predModelType = this.getCSLoc(predicatedModelPath);
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)modelType)).texture("layer0", "item/" + name)).override().predicate(predicate, 1.0f).model((ModelFile)this.getBuilder(name + "_" + predicate.m_135815_()));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name + "_" + predicate.m_135815_())).parent((ModelFile)predModelType)).texture("layer0", "item/" + name + "_" + predicate.m_135815_());
    }

    public ModelFile.ExistingModelFile getMcLoc(String mcModel) {
        return this.getExistingFile(this.mcLoc(mcModel));
    }

    public ModelFile.ExistingModelFile getCSLoc(String csModel) {
        return this.getExistingFile(this.csLoc(csModel));
    }

    public ResourceLocation csLoc(String name) {
        return Celestisynth.prefix(name);
    }
}

