/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.world.structure;

import com.aqutheseal.celestisynth.common.registry.CSBlocks;
import com.aqutheseal.celestisynth.common.registry.CSStructures;
import com.aqutheseal.celestisynth.common.world.structure.BlockPlacerPiece;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class WintereisClusterPiece
extends BlockPlacerPiece {
    public static final int CENTER_PIECE = 0;
    public static final int CONNECTOR_FOUR_WAY = 1;
    public static final int CONNECTOR_CORNER = 3;
    public static final int CONNECTOR_END = 4;
    public int type;

    public WintereisClusterPiece(RandomSource pRandom, BlockPos pos, Direction orientation, int type) {
        super((StructurePieceType)CSStructures.WINTEREIS_CLUSTER_PIECE.get(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 48, 48, 48, orientation);
        this.type = type;
    }

    public WintereisClusterPiece(CompoundTag pTag) {
        super((StructurePieceType)CSStructures.WINTEREIS_CLUSTER_PIECE.get(), pTag);
        this.type = pTag.m_128451_("Type");
    }

    protected void m_183620_(StructurePieceSerializationContext pContext, CompoundTag pTag) {
        super.m_183620_(pContext, pTag);
        pTag.m_128405_("Type", this.type);
    }

    @Override
    public void generatePiece(WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, BlockPos pos) {
        if (this.type == 0) {
            this.buildDiamond(level, ((Block)CSBlocks.WINTEREIS.get()).m_49966_(), pos, box, 10, 0.4, false);
            for (Pair corner : this.get8WayPoses(4)) {
                this.buildDiamond(level, ((Block)CSBlocks.WINTEREIS.get()).m_49966_(), pos.m_7918_(((Integer)corner.getFirst()).intValue(), 0, ((Integer)corner.getSecond()).intValue()), box, 4, 0.25, false);
            }
            for (Pair corner : this.getCornerPoses(20)) {
                this.buildDiamond(level, Blocks.f_50378_.m_49966_(), pos.m_7918_(((Integer)corner.getFirst()).intValue(), 16, ((Integer)corner.getSecond()).intValue()), box, 4, 0.3, true);
            }
            this.buildCircle(level, Blocks.f_50378_.m_49966_(), pos, box, 20);
            this.buildCircle(level, Blocks.f_50379_.m_49966_(), pos.m_6630_(12), box, 14);
            this.buildCircle(level, Blocks.f_50379_.m_49966_(), pos.m_6630_(20), box, 8);
            this.buildCircle(level, Blocks.f_50379_.m_49966_(), pos.m_6625_(12), box, 14);
            this.buildCircle(level, Blocks.f_50379_.m_49966_(), pos.m_6625_(20), box, 8);
            this.constructBridgeSet(level, Blocks.f_50378_.m_49966_(), pos, box, 16);
        }
        if (this.type == 1) {
            this.buildDiamond(level, Blocks.f_50126_.m_49966_(), pos, box, 8, 0.5, false);
            this.constructBridgeSet(level, Blocks.f_50378_.m_49966_(), pos, box, 12);
        }
        if (this.type == 3) {
            this.buildDiamond(level, Blocks.f_50126_.m_49966_(), pos, box, 4, 0.5, false);
            this.constructBridgeSet(level, Blocks.f_50378_.m_49966_(), pos, box, 8);
            for (Pair corner : this.getCornerPoses(12)) {
                this.buildDiamond(level, Blocks.f_50378_.m_49966_(), pos.m_7918_(((Integer)corner.getFirst()).intValue(), 0, ((Integer)corner.getSecond()).intValue()), box, 3, 0.3, true);
            }
        }
        if (this.type == 4) {
            this.buildDiamond(level, Blocks.f_50126_.m_49966_(), pos, box, 2, 0.5, false);
            this.constructBridgeSet(level, Blocks.f_50378_.m_49966_(), pos, box, 6);
        }
    }

    public void buildCircle(WorldGenLevel level, BlockState blockState, BlockPos pos, BoundingBox box, int radius) {
        for (int cr = 0; cr <= 360; ++cr) {
            this.putBlock(level, blockState, pos.m_7918_((int)(Math.sin(cr) * (double)radius), 0, (int)(Math.cos(cr) * (double)radius)), box);
        }
    }

    public void constructBridgeSet(WorldGenLevel level, BlockState blockState, BlockPos pos, BoundingBox box, int radius) {
        this.buildCircle(level, blockState, pos, box, radius);
        if (this.type == 0 || this.type == 1) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                this.buildBridge(level, blockState, pos, box, radius, direction);
            }
        }
        if (this.type == 3 && Direction.Plane.HORIZONTAL.test(this.m_73549_())) {
            this.buildBridge(level, blockState, pos, box, radius, this.m_73549_());
            this.buildBridge(level, blockState, pos, box, radius, this.m_73549_().m_122427_());
        }
        if (this.type == 4 && Direction.Plane.HORIZONTAL.test(this.m_73549_())) {
            this.buildBridge(level, blockState, pos, box, radius, this.m_73549_());
        }
    }

    public void buildBridge(WorldGenLevel level, BlockState blockState, BlockPos pos, BoundingBox box, int radius, Direction direction) {
        switch (direction) {
            case NORTH: {
                for (int sz = -radius; sz >= -24; --sz) {
                    for (int sx = -2; sx <= 2; ++sx) {
                        this.putBlock(level, blockState, pos.m_7918_(sx, 0, sz), box);
                    }
                }
                break;
            }
            case EAST: {
                for (int sx = radius; sx <= 24; ++sx) {
                    for (int sz = -2; sz <= 2; ++sz) {
                        this.putBlock(level, blockState, pos.m_7918_(sx, 0, sz), box);
                    }
                }
                break;
            }
            case SOUTH: {
                for (int sz = radius; sz <= 24; ++sz) {
                    for (int sx = -2; sx <= 2; ++sx) {
                        this.putBlock(level, blockState, pos.m_7918_(sx, 0, sz), box);
                    }
                }
                break;
            }
            case WEST: {
                for (int sx = -radius; sx >= -24; --sx) {
                    for (int sz = -2; sz <= 2; ++sz) {
                        this.putBlock(level, blockState, pos.m_7918_(sx, 0, sz), box);
                    }
                }
                break;
            }
        }
    }

    public void buildDiamond(WorldGenLevel level, BlockState blockState, BlockPos pos, BoundingBox box, int radius, double heightMod, boolean generateBelow) {
        for (int sy = -64; sy <= 64; ++sy) {
            for (int sx = -radius; sx <= radius; ++sx) {
                for (int sz = -radius; sz <= radius; ++sz) {
                    if (!((double)(Math.abs(sx) + Math.abs(sz)) + Math.abs((double)sy * heightMod) <= (double)radius) || !(Math.pow(sx, 2.0) + Math.pow(sz, 2.0) <= (double)radius)) continue;
                    BlockPos.MutableBlockPos offset = pos.m_122032_().m_122184_(sx, sy, sz);
                    if (generateBelow) {
                        for (int ty = offset.m_123342_(); ty > level.m_141937_(); --ty) {
                            this.putBlock(level, blockState, (BlockPos)offset, box);
                            offset.m_122173_(Direction.DOWN);
                        }
                        continue;
                    }
                    this.putBlock(level, blockState, (BlockPos)offset, box);
                }
            }
        }
    }

    public ImmutableList<Pair<Integer, Integer>> get8WayPoses(int multiplier) {
        ArrayList<Pair> list = new ArrayList<Pair>(List.of(Pair.of((Object)(multiplier * 2), (Object)0), Pair.of((Object)0, (Object)(-multiplier * 2)), Pair.of((Object)(-multiplier * 2), (Object)0), Pair.of((Object)0, (Object)(multiplier * 2))));
        list.addAll((Collection<Pair>)this.getCornerPoses(multiplier));
        return ImmutableList.copyOf(list);
    }

    public ImmutableList<Pair<Integer, Integer>> getCornerPoses(int multiplier) {
        return ImmutableList.of((Object)Pair.of((Object)multiplier, (Object)multiplier), (Object)Pair.of((Object)multiplier, (Object)(-multiplier)), (Object)Pair.of((Object)(-multiplier), (Object)multiplier), (Object)Pair.of((Object)(-multiplier), (Object)(-multiplier)));
    }
}

