/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.world.feature;

import com.aqutheseal.celestisynth.common.registry.CSBlocks;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.phys.Vec3;

public class WintereisSpikesFeature
extends Feature<NoneFeatureConfiguration> {
    public WintereisSpikesFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pTarget = context.m_159777_();
        WorldGenLevel pLevel = context.m_159774_();
        RandomSource pRandom = context.m_225041_();
        if (this.isBigCave(pLevel, pTarget, 10)) {
            int tip = 13 + pRandom.m_188503_(7);
            int topX = -10 + pRandom.m_188503_(10);
            int topZ = -10 + pRandom.m_188503_(10);
            int radius = 1 + pRandom.m_188503_(3);
            Vec3 to = new Vec3((double)(pTarget.m_123341_() + topX), (double)(pTarget.m_123342_() + tip), (double)(pTarget.m_123343_() + topZ));
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    double fromCenter = Math.sqrt(x * x + z * z);
                    if (!(fromCenter <= (double)radius)) continue;
                    Vec3 from = new Vec3((double)(pTarget.m_123341_() + x), (double)pTarget.m_123342_(), (double)(pTarget.m_123343_() + z));
                    Vec3 per = to.m_82546_(from).m_82541_();
                    Vec3 current = from.m_82520_(0.0, 0.0, 0.0);
                    double distance = from.m_82554_(to);
                    for (double i = 0.0; i < distance; i += 1.0) {
                        BlockPos targetPos = this.posFromVec(current);
                        if (i >= 0.0 && i < distance / (4.0 - pRandom.m_188500_())) {
                            this.setBlockConditioned(pLevel, targetPos, Blocks.f_152550_.m_49966_());
                        } else {
                            this.setBlockConditioned(pLevel, targetPos, ((Block)CSBlocks.WINTEREIS.get()).m_49966_());
                        }
                        current = current.m_82549_(per);
                        if (!(i <= 0.0)) continue;
                        BlockPos getFromTarget = targetPos;
                        while (pLevel.m_46859_(getFromTarget.m_7495_())) {
                            this.setBlockConditioned(pLevel, getFromTarget, Blocks.f_152550_.m_49966_());
                            getFromTarget = getFromTarget.m_7495_();
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean isBigCave(WorldGenLevel level, BlockPos pos, int height) {
        for (int i = 1; i < height; ++i) {
            if (level.m_8055_(pos.m_6630_(i)).m_60795_()) continue;
            return false;
        }
        return true;
    }

    protected void setBlockConditioned(WorldGenLevel pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.m_8055_(pPos).m_60795_()) {
            super.m_5974_((LevelWriter)pLevel, pPos, pState);
        }
    }

    public BlockPos posFromVec(Vec3 vec3) {
        return new BlockPos((int)vec3.m_7096_(), (int)vec3.m_7098_(), (int)vec3.m_7094_());
    }
}

