/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.registry;

import com.aqutheseal.celestisynth.common.block.CelestialCraftingTable;
import com.aqutheseal.celestisynth.common.block.SolarCrystalBlock;
import com.aqutheseal.celestisynth.common.block.StarlitFactoryBlock;
import com.aqutheseal.celestisynth.common.item.misc.StarlitFactoryBlockItem;
import com.aqutheseal.celestisynth.common.registry.CSItems;
import com.aqutheseal.celestisynth.common.registry.CSRarityTypes;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class CSBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"celestisynth");
    public static final RegistryObject<Block> SOLAR_CRYSTAL = CSBlocks.registerBlock("solar_crystal", () -> new SolarCrystalBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50058_).m_284180_(MapColor.f_283913_).m_60918_(SoundType.f_56744_).m_60999_().m_60913_(3.0f, 9.0f).m_280606_().m_60955_().m_60991_((a, b, c) -> true).m_60953_(a -> 15)));
    public static final RegistryObject<Block> LUNAR_STONE = CSBlocks.registerBlock("lunar_stone", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152550_).m_284180_(MapColor.f_283908_).m_60918_(SoundType.f_56742_).m_60999_().m_60913_(4.0f, 9.0f).m_60953_(a -> 3)));
    public static final RegistryObject<Block> ZEPHYR_DEPOSIT = CSBlocks.registerBlock("zephyr_deposit", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152550_).m_284180_(MapColor.f_283916_).m_60918_(SoundType.f_56730_).m_60999_().m_60913_(60.5f, 9.0f).m_60953_(a -> 3)));
    public static final RegistryObject<Block> WINTEREIS = CSBlocks.registerBlock("wintereis", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50126_).m_284180_(MapColor.f_283869_).m_60918_(SoundType.f_154654_).m_60999_().m_60911_(0.7f).m_60913_(55.0f, 8.0f).m_60953_(a -> 3)));
    public static final RegistryObject<Block> CELESTIAL_CRAFTING_TABLE = CSBlocks.registerBlock("celestial_crafting_table", () -> new CelestialCraftingTable(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50322_).m_284180_(MapColor.f_283908_).m_60918_(SoundType.f_56725_).m_60955_().m_60999_().m_60913_(60.5f, 9.0f).m_60953_(a -> 7)));
    public static final RegistryObject<Block> STARLIT_FACTORY = CSBlocks.registerStarlitFactoryBlockItem("starlit_factory", () -> new StarlitFactoryBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50322_).m_284180_(MapColor.f_283908_).m_60918_(SoundType.f_56725_).m_60955_().m_60999_().m_60913_(60.5f, 9.0f).m_60953_(a -> 7)));

    private static <T extends Block> RegistryObject<T> registerStarlitFactoryBlockItem(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        CSItems.ITEMS.register(name, () -> new StarlitFactoryBlockItem((Block)toReturn.get(), new Item.Properties().m_41486_().m_41497_(CSRarityTypes.CELESTIAL)));
        return toReturn;
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        CSBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return CSItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }
}

