/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.recipe;

import com.aqutheseal.celestisynth.common.recipe.StarlitFactoryRecipe;
import com.aqutheseal.celestisynth.common.registry.CSRecipeTypes;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class StarlitFactoryRecipeBuilder
implements RecipeBuilder {
    protected final Ingredient baseMaterial;
    protected final Ingredient baseMaterial1;
    protected final Ingredient baseMaterial2;
    protected final Ingredient supportingMaterial;
    protected final Ingredient supportingMaterial1;
    protected final Ingredient supportingMaterial2;
    protected final Item result;
    protected final int forgeTime;
    private final RecipeSerializer<? extends StarlitFactoryRecipe> serializer;

    public StarlitFactoryRecipeBuilder(Ingredient baseMaterial, Ingredient baseMaterial1, Ingredient baseMaterial2, Ingredient supportingMaterial, Ingredient supportingMaterial1, Ingredient supportingMaterial2, ItemLike result, int forgeTime) {
        this.baseMaterial = baseMaterial;
        this.baseMaterial1 = baseMaterial1;
        this.baseMaterial2 = baseMaterial2;
        this.supportingMaterial = supportingMaterial;
        this.supportingMaterial1 = supportingMaterial1;
        this.supportingMaterial2 = supportingMaterial2;
        this.result = result.m_5456_();
        this.forgeTime = forgeTime;
        this.serializer = (RecipeSerializer)CSRecipeTypes.STARLIT_FACTORY.get();
    }

    public static StarlitFactoryRecipeBuilder starlitFactory(Ingredient baseMaterial, Ingredient baseMaterial1, Ingredient baseMaterial2, Ingredient supportingMaterial, Ingredient supportingMaterial1, Ingredient supportingMaterial2, ItemLike result, int forgeTime) {
        return new StarlitFactoryRecipeBuilder(baseMaterial, baseMaterial1, baseMaterial2, supportingMaterial, supportingMaterial1, supportingMaterial2, result, forgeTime);
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.baseMaterial, this.baseMaterial1, this.baseMaterial2, this.supportingMaterial, this.supportingMaterial1, this.supportingMaterial2, this.result, this.forgeTime));
    }

    public Item m_142372_() {
        return this.result;
    }

    public RecipeBuilder m_126132_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        return this;
    }

    static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        protected final Ingredient baseMaterial;
        protected final Ingredient baseMaterial1;
        protected final Ingredient baseMaterial2;
        protected final Ingredient supportingMaterial;
        protected final Ingredient supportingMaterial1;
        protected final Ingredient supportingMaterial2;
        protected final Item result;
        protected final int forgeTime;

        Result(ResourceLocation id, Ingredient baseMaterial, Ingredient baseMaterial1, Ingredient baseMaterial2, Ingredient supportingMaterial, Ingredient supportingMaterial1, Ingredient supportingMaterial2, Item result, int forgeTime) {
            this.id = id;
            this.baseMaterial = baseMaterial;
            this.baseMaterial1 = baseMaterial1;
            this.baseMaterial2 = baseMaterial2;
            this.supportingMaterial = supportingMaterial;
            this.supportingMaterial1 = supportingMaterial1;
            this.supportingMaterial2 = supportingMaterial2;
            this.result = result;
            this.forgeTime = forgeTime;
        }

        public void m_7917_(JsonObject pJson) {
            pJson.add("core_material", this.baseMaterial.m_43942_());
            pJson.add("supporting_core_material", this.baseMaterial1.m_43942_());
            pJson.add("extra_core_material", this.baseMaterial2.m_43942_());
            pJson.add("supporting_material_top", this.supportingMaterial.m_43942_());
            pJson.add("supporting_material_middle", this.supportingMaterial1.m_43942_());
            pJson.add("supporting_material_bottom", this.supportingMaterial2.m_43942_());
            pJson.addProperty("result", BuiltInRegistries.f_257033_.m_7981_((Object)this.result).toString());
            pJson.addProperty("forging_time", (Number)this.forgeTime);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)CSRecipeTypes.STARLIT_FACTORY.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

