/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.network.s2c;

import com.aqutheseal.celestisynth.api.item.TieredItemStats;
import com.aqutheseal.celestisynth.common.registry.CSDataLoaders;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class UpdateStatsPacket {
    private static final Codec<Map<ResourceLocation, TieredItemStats>> MAPPER = Codec.unboundedMap((Codec)ResourceLocation.f_135803_, TieredItemStats.CODEC);
    private final Map<ResourceLocation, TieredItemStats> data;

    public UpdateStatsPacket(Map<ResourceLocation, TieredItemStats> data) {
        this.data = data;
    }

    public UpdateStatsPacket(FriendlyByteBuf buf) {
        this.data = MAPPER.parse((DynamicOps)NbtOps.f_128958_, (Object)buf.m_130260_()).result().orElseGet(Object2ObjectLinkedOpenHashMap::new);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(MAPPER.encodeStart((DynamicOps)NbtOps.f_128958_, this.data).result().orElse(new CompoundTag()));
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(this::setAnimMetadata);
        ctx.get().setPacketHandled(true);
        return true;
    }

    private void setAnimMetadata() {
        CSDataLoaders.TIERED_ITEM_STATS.setData(this.data);
    }
}

