/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.network.s2c;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class BlockEntitySetSlotPacket {
    private final BlockPos blockEntityPosition;
    private final int itemSlot;
    private final ItemStack itemStack;

    public BlockEntitySetSlotPacket(BlockPos blockEntityPosition, int itemSlot, ItemStack itemStack) {
        this.blockEntityPosition = blockEntityPosition;
        this.itemSlot = itemSlot;
        this.itemStack = itemStack;
    }

    public BlockEntitySetSlotPacket(FriendlyByteBuf buf) {
        this.blockEntityPosition = buf.m_130135_();
        this.itemSlot = buf.readInt();
        this.itemStack = buf.m_130267_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.blockEntityPosition);
        buf.writeInt(this.itemSlot);
        buf.m_130055_(this.itemStack);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Minecraft instance = Minecraft.m_91087_();
            BlockEntity blockEntity = instance.f_91073_.m_7702_(this.blockEntityPosition);
            if (blockEntity instanceof Container) {
                Container container = (Container)blockEntity;
                container.m_6836_(this.itemSlot, this.itemStack);
            }
        });
        return true;
    }
}

