/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.item.weapons;

import com.aqutheseal.celestisynth.api.item.CSGeoItem;
import com.aqutheseal.celestisynth.api.item.CSWeaponUtil;
import com.aqutheseal.celestisynth.common.attack.base.WeaponAttackInstance;
import com.aqutheseal.celestisynth.common.attack.solaris.SolarisFullRoundAttack;
import com.aqutheseal.celestisynth.common.attack.solaris.SolarisSoulDashAttack;
import com.aqutheseal.celestisynth.common.compat.bettercombat.SwingParticleContainer;
import com.aqutheseal.celestisynth.common.entity.projectile.SolarisBomb;
import com.aqutheseal.celestisynth.common.item.base.SkilledSwordItem;
import com.aqutheseal.celestisynth.common.registry.CSEntityTypes;
import com.aqutheseal.celestisynth.common.registry.CSParticleTypes;
import com.aqutheseal.celestisynth.common.registry.CSSoundEvents;
import com.aqutheseal.celestisynth.util.ParticleUtil;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;

public class SolarisItem
extends SkilledSwordItem
implements CSGeoItem {
    public SolarisItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Override
    public String geoIdentifier() {
        return "solaris";
    }

    @Override
    public String texture(ItemStack stack) {
        if (this.attackController(stack) != null && this.attackController(stack).m_128471_("cs.hasStartedSoulDash")) {
            return "solaris_soul";
        }
        return "solaris";
    }

    @Override
    public GeoAnimatable cacheItem() {
        return this;
    }

    @Override
    public ImmutableList<WeaponAttackInstance> getPossibleAttacks(Player player, ItemStack stack, int dur) {
        return ImmutableList.of((Object)new SolarisFullRoundAttack(player, stack), (Object)new SolarisSoulDashAttack(player, stack));
    }

    @Override
    @Nullable
    public SwingParticleContainer getSwingContainer(LivingEntity holder, ItemStack stack) {
        return new SwingParticleContainer((ParticleType)CSParticleTypes.SOLARIS_FLAME.get(), 0.8f);
    }

    @Override
    public int getSkillsAmount() {
        return 2;
    }

    @Override
    public int getPassiveAmount() {
        return 2;
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        ServerLevel server;
        List<SolarisBomb> bombs;
        super.m_5929_(pLevel, pLivingEntity, pStack, pRemainingUseDuration);
        int dur = this.m_8105_(pStack) - pRemainingUseDuration;
        double xV = Mth.m_14031_((float)dur) * 3.0f;
        double zV = Mth.m_14089_((float)dur) * 3.0f;
        ParticleUtil.sendParticle(pLevel, ParticleTypes.f_123759_, pLivingEntity.m_20185_() + xV, pLivingEntity.m_20186_() + 1.5, pLivingEntity.m_20189_() + zV, xV * 0.05, 0.0, zV * 0.05);
        if (dur % 40 == 0) {
            pLivingEntity.m_5496_((SoundEvent)CSSoundEvents.WHIRLWIND.get(), 0.2f, (float)(1.0 + pLevel.f_46441_.m_188583_() * 0.25));
        }
        if (dur % 30 == 0 && pLevel instanceof ServerLevel && (bombs = SolarisBomb.getAllBombsOwnedBy(pLivingEntity, server = (ServerLevel)pLevel).filter(e -> e.m_20280_((Entity)pLivingEntity) <= 32.0).toList()).size() < 5) {
            SolarisBomb bomb = new SolarisBomb((EntityType<? extends ThrowableProjectile>)((EntityType)CSEntityTypes.SOLARIS_BOMB.get()), pLivingEntity, pLevel);
            bomb.m_5602_((Entity)pLivingEntity);
            bomb.m_216990_(SoundEvents.f_11705_);
            pLevel.m_7967_((Entity)bomb);
            for (int i = 0; i < 360; ++i) {
                double xI = Mth.m_14031_((float)i) * 3.0f;
                double zI = Mth.m_14089_((float)i) * 3.0f;
                ParticleUtil.sendParticle(pLevel, ParticleTypes.f_123744_, pLivingEntity.m_20185_(), pLivingEntity.m_20186_() + 1.2, pLivingEntity.m_20189_(), xI * 0.05, 0.0, zI * 0.05);
            }
        }
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.TOOT_HORN;
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity entity, LivingEntity source) {
        entity.m_20254_(5);
        return super.m_7579_(itemStack, entity, source);
    }

    @Override
    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (isSelected || player.m_21206_().m_41720_() instanceof SolarisItem) {
                player.m_7292_(CSWeaponUtil.nonVisiblePotionEffect(MobEffects.f_19607_, 2, 0));
            }
        }
        super.m_6883_(itemStack, level, entity, itemSlot, isSelected);
    }
}

