/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.item.weapons;

import com.aqutheseal.celestisynth.api.item.CSGeoItem;
import com.aqutheseal.celestisynth.api.item.CSWeaponUtil;
import com.aqutheseal.celestisynth.common.attack.base.WeaponAttackInstance;
import com.aqutheseal.celestisynth.common.attack.poltergeist.PoltergeistBarrierCallAttack;
import com.aqutheseal.celestisynth.common.attack.poltergeist.PoltergeistCosmicSteelAttack;
import com.aqutheseal.celestisynth.common.item.base.SkilledAxeItem;
import com.google.common.collect.ImmutableList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;

public class PoltergeistItem
extends SkilledAxeItem
implements CSGeoItem {
    public PoltergeistItem(Tier tier, int attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, attackDamage, attackSpeed, properties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Override
    public String geoIdentifier() {
        return "poltergeist";
    }

    @Override
    public String texture(ItemStack stack) {
        if (this.attackExtras(stack).m_128471_("cs.isImpactLarge")) {
            return "poltergeist_haunted";
        }
        return "poltergeist";
    }

    @Override
    public GeoAnimatable cacheItem() {
        return this;
    }

    @Override
    public int getSkillsAmount() {
        return 2;
    }

    @Override
    public int getPassiveAmount() {
        return 1;
    }

    @Override
    public ImmutableList<WeaponAttackInstance> getPossibleAttacks(Player player, ItemStack stack, int useDuration) {
        return ImmutableList.of((Object)new PoltergeistCosmicSteelAttack(player, stack), (Object)new PoltergeistBarrierCallAttack(player, stack));
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity entity, LivingEntity source) {
        entity.m_7292_(CSWeaponUtil.nonVisiblePotionEffect(MobEffects.f_216964_, 60, 0));
        return super.m_7579_(itemStack, entity, source);
    }

    @Override
    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(itemStack, level, entity, itemSlot, isSelected);
        CompoundTag data = itemStack.m_41698_("csController");
        if (data.m_128471_("cs.hasAnimationBegun") && entity instanceof Player) {
            Player player = (Player)entity;
            player.m_7292_(CSWeaponUtil.nonVisiblePotionEffect(MobEffects.f_19606_, 2, 2));
        }
    }
}

