/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.item.weapons;

import com.aqutheseal.celestisynth.api.item.CSGeoItem;
import com.aqutheseal.celestisynth.api.item.CSWeaponUtil;
import com.aqutheseal.celestisynth.common.attack.base.WeaponAttackInstance;
import com.aqutheseal.celestisynth.common.attack.cresentia.CrescentiaBarrageAttack;
import com.aqutheseal.celestisynth.common.attack.cresentia.CrescentiaDragonAttack;
import com.aqutheseal.celestisynth.common.item.base.SkilledSwordItem;
import com.aqutheseal.celestisynth.common.registry.CSParticleTypes;
import com.aqutheseal.celestisynth.util.ParticleUtil;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;

public class CrescentiaItem
extends SkilledSwordItem
implements CSGeoItem {
    public CrescentiaItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Override
    public String geoIdentifier() {
        return "crescentia";
    }

    @Override
    public GeoAnimatable cacheItem() {
        return this;
    }

    @Override
    public ImmutableList<WeaponAttackInstance> getPossibleAttacks(Player player, ItemStack stack, int dur) {
        return ImmutableList.of((Object)new CrescentiaBarrageAttack(player, stack), (Object)new CrescentiaDragonAttack(player, stack));
    }

    @Override
    public int getSkillsAmount() {
        return 2;
    }

    @Override
    public int getPassiveAmount() {
        return 1;
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity entity, LivingEntity source) {
        entity.m_7292_(CSWeaponUtil.nonVisiblePotionEffect(MobEffects.f_19597_, 40, 2));
        return super.m_7579_(itemStack, entity, source);
    }

    @Override
    public void m_6883_(ItemStack itemStack, @NotNull Level level, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (isSelected || player.m_21206_().m_41720_() instanceof CrescentiaItem) {
                player.m_7292_(CSWeaponUtil.nonVisiblePotionEffect(MobEffects.f_19606_, 2, 0));
            }
        }
        super.m_6883_(itemStack, level, entity, itemSlot, isSelected);
    }

    public static void createCrescentiaFirework(ItemStack itemStack, Level level, Player player, double x, double y, double z, boolean isBig) {
        RandomSource random = level.f_46441_;
        ParticleType[] particleTypes = new ParticleType[]{(ParticleType)CSParticleTypes.CRESCENTIA_FIREWORK_PURPLE.get(), (ParticleType)CSParticleTypes.CRESCENTIA_FIREWORK_PINK.get(), (ParticleType)CSParticleTypes.CRESCENTIA_FIREWORK_BLUE.get()};
        ParticleType firework = particleTypes[random.m_188503_(particleTypes.length)];
        for (int i = 0; i < 45; ++i) {
            double xx = random.m_188583_() * (isBig ? 0.15 : 0.05);
            double yy = random.m_188583_() * (isBig ? 0.15 : 0.05);
            double zz = random.m_188583_() * (isBig ? 0.15 : 0.05);
            ParticleUtil.sendParticle(level, firework, x, y, z, xx, yy, zz);
        }
        ParticleUtil.sendParticle(level, ParticleTypes.f_123747_, x, y, z);
        player.m_5496_(SoundEvents.f_11930_, 1.0f, 0.5f + random.m_188501_());
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        ObjectArrayList enchantments = new ObjectArrayList();
        enchantments.add(Enchantments.f_44959_);
        if (enchantments.contains(enchantment)) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }
}

