/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.item.weapons;

import com.aqutheseal.celestisynth.api.item.CSGeoItem;
import com.aqutheseal.celestisynth.api.item.CSWeaponUtil;
import com.aqutheseal.celestisynth.common.attack.base.WeaponAttackInstance;
import com.aqutheseal.celestisynth.common.attack.breezebreaker.BreezebreakerDualGalestormAttack;
import com.aqutheseal.celestisynth.common.attack.breezebreaker.BreezebreakerGalestormAttack;
import com.aqutheseal.celestisynth.common.attack.breezebreaker.BreezebreakerWheelAttack;
import com.aqutheseal.celestisynth.common.attack.breezebreaker.BreezebreakerWhirlwindAttack;
import com.aqutheseal.celestisynth.common.attack.breezebreaker.BreezebreakerWindRoarAttack;
import com.aqutheseal.celestisynth.common.item.base.SkilledSwordItem;
import com.aqutheseal.celestisynth.common.registry.CSParticleTypes;
import com.aqutheseal.celestisynth.util.ParticleUtil;
import com.google.common.collect.ImmutableList;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;

public class BreezebreakerItem
extends SkilledSwordItem
implements CSGeoItem {
    public static final String BB_COMBO_POINTS = "cs.bbCombo";
    public static final String AT_BUFF_STATE = "cs.bbBuffState";
    public static final String BUFF_STATE_LIMITER = "cs.bbBuffStateLimiter";

    public BreezebreakerItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    @Override
    public String geoIdentifier() {
        return "breezebreaker";
    }

    @Override
    public GeoAnimatable cacheItem() {
        return this;
    }

    @Override
    public ImmutableList<WeaponAttackInstance> getPossibleAttacks(Player player, ItemStack stack, int useDuration) {
        return ImmutableList.of((Object)new BreezebreakerGalestormAttack(player, stack, useDuration), (Object)new BreezebreakerDualGalestormAttack(player, stack, useDuration), (Object)new BreezebreakerWheelAttack(player, stack, useDuration), (Object)new BreezebreakerWhirlwindAttack(player, stack, useDuration), (Object)new BreezebreakerWindRoarAttack(player, stack, useDuration));
    }

    @Override
    public int getSkillsAmount() {
        return 5;
    }

    @Override
    public int getPassiveAmount() {
        return 2;
    }

    @Override
    public void m_6883_(ItemStack itemStack, Level level, Entity owner, int itemSlot, boolean isSelected) {
        super.m_6883_(itemStack, level, owner, itemSlot, isSelected);
        CompoundTag extrasData = itemStack.m_41698_("csExtras");
        if (owner instanceof Player) {
            Player playerOwner = (Player)owner;
            if (isSelected || playerOwner.m_21206_().m_41720_() instanceof BreezebreakerItem) {
                this.sendExpandingParticles(level, (ParticleType)ParticleTypes.f_123810_, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), 1, 0.1f);
            }
        }
        if (extrasData.m_128471_(AT_BUFF_STATE)) {
            if (owner instanceof Player) {
                Player player = (Player)owner;
                player.m_7292_(CSWeaponUtil.nonVisiblePotionEffect(MobEffects.f_19596_, 2, 1));
                double radius = 1.5 + (double)player.m_20205_();
                double speed = 0.5;
                double offX = radius * Math.sin(speed * (double)player.f_19797_);
                double offY = player.m_20206_() / 2.0f;
                double offZ = radius * Math.cos(speed * (double)player.f_19797_);
                ParticleUtil.sendParticle(level, (SimpleParticleType)CSParticleTypes.BREEZEBROKEN.get(), player.m_20185_() + offX, player.m_20186_() + offY, player.m_20189_() + offZ);
            }
            extrasData.m_128405_(BUFF_STATE_LIMITER, extrasData.m_128451_(BUFF_STATE_LIMITER) + 1);
            if (extrasData.m_128451_(BUFF_STATE_LIMITER) >= 200) {
                extrasData.m_128379_(AT_BUFF_STATE, false);
                extrasData.m_128405_(BB_COMBO_POINTS, 0);
                extrasData.m_128405_(BUFF_STATE_LIMITER, 0);
            }
        }
    }

    @Override
    public void onPlayerHurt(LivingHurtEvent event, ItemStack stack) {
        if (event.getSource() == event.getEntity().m_269291_().m_268989_()) {
            event.setCanceled(true);
        } else {
            event.setAmount(event.getAmount() * 1.65f);
        }
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 72000;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }
}

