/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.entity.skillcast;

import com.aqutheseal.celestisynth.api.item.AttackHurtTypes;
import com.aqutheseal.celestisynth.common.capabilities.CSEntityCapabilityProvider;
import com.aqutheseal.celestisynth.common.entity.base.CSEffectEntity;
import com.aqutheseal.celestisynth.common.entity.base.EffectControllerEntity;
import com.aqutheseal.celestisynth.common.entity.helper.CSVisualType;
import com.aqutheseal.celestisynth.common.registry.CSEntityTypes;
import com.aqutheseal.celestisynth.common.registry.CSParticleTypes;
import com.aqutheseal.celestisynth.common.registry.CSSoundEvents;
import com.aqutheseal.celestisynth.common.registry.CSVisualTypes;
import com.aqutheseal.celestisynth.util.ParticleUtil;
import com.aqutheseal.celestisynth.util.SkinUtil;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class SkillCastFrostboundIceCast
extends EffectControllerEntity {
    private static final EntityDataAccessor<Integer> CAST_LEVEL = SynchedEntityData.m_135353_(SkillCastFrostboundIceCast.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public SkillCastFrostboundIceCast(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void m_8119_() {
        int i;
        CSVisualType impact;
        SimpleParticleType particle;
        Pair sound;
        Player ownerPlayer;
        UUID ownerUuid = this.m_21805_();
        Player player = ownerPlayer = ownerUuid == null ? null : this.m_9236_().m_46003_(ownerUuid);
        if (SkinUtil.getSkinIndex(this.getOriginItem()) == 1) {
            sound = Pair.of((Object)((SoundEvent)CSSoundEvents.ICE_CAST.get()), (Object)SoundEvents.f_12324_);
            particle = (ParticleType)CSParticleTypes.WATER_DROP.get();
            impact = (CSVisualType)CSVisualTypes.FROSTBOUND_ICE_CAST_SEABR.get();
        } else {
            sound = Pair.of((Object)((SoundEvent)CSSoundEvents.ICE_CAST.get()), (Object)SoundEvents.f_144205_);
            particle = ParticleTypes.f_175821_;
            impact = (CSVisualType)CSVisualTypes.FROSTBOUND_ICE_CAST.get();
        }
        if (this.f_19797_ == 1 && this.getCastLevel() > 0) {
            this.m_216990_((SoundEvent)sound.getFirst());
            for (i = 0; i < 360; i += 2) {
                double xI = Mth.m_14031_((float)i) * 3.0f;
                double zI = Mth.m_14089_((float)i) * 3.0f;
                ParticleUtil.sendParticles(this.m_9236_(), particle, this.m_20185_() + xI, this.m_20186_(), this.m_20189_() + zI, 1, -xI / 8.0, 0.0, -zI / 8.0);
            }
        }
        if (this.f_19797_ == 5 && this.getCastLevel() > 0 && !this.m_9236_().m_5776_()) {
            SkillCastFrostboundIceCast frostboundIceCast = (SkillCastFrostboundIceCast)((EntityType)CSEntityTypes.FROSTBOUND_ICE_CAST.get()).m_20615_(this.m_9236_());
            float aX = this.getAngleX();
            float aZ = this.getAngleZ();
            int floorPos = this.getFloorPositionUnderPlayerYLevel(this.m_9236_(), this.m_20183_().m_7918_((int)aX, 0, (int)aZ));
            frostboundIceCast.setOwnerUUID(ownerUuid);
            frostboundIceCast.setOriginItem(this.getOriginItem());
            frostboundIceCast.setCastLevel(this.getCastLevel() - 1);
            frostboundIceCast.setAngleX(aX);
            frostboundIceCast.setAngleZ(aZ);
            frostboundIceCast.m_6027_(this.m_20185_() + (double)aX, floorPos + 2, this.m_20189_() + (double)aZ);
            frostboundIceCast.damage = this.damage;
            this.m_9236_().m_7967_((Entity)frostboundIceCast);
        }
        if (this.f_19797_ == 20 && this.getCastLevel() > 0) {
            CSEffectEntity.createInstance((LivingEntity)ownerPlayer, this, impact, 0.0, 0.5, 0.0);
            for (i = 0; i < 360; i += 4) {
                double xI = Mth.m_14031_((float)i) * 3.0f;
                double zI = Mth.m_14089_((float)i) * 3.0f;
                ParticleUtil.sendParticles(this.m_9236_(), particle, this.m_20185_(), this.m_20186_() - 1.0, this.m_20189_(), 1, xI / 10.0, 0.3, zI / 10.0);
            }
            double range = 1.0;
            List entities = this.m_9236_().m_45976_(Entity.class, new AABB(this.m_20185_() + range, this.m_20186_() + range * 3.0, this.m_20189_() + range, this.m_20185_() - range, this.m_20186_(), this.m_20189_() - range));
            for (Entity entityBatch : entities) {
                LivingEntity target;
                if (!(entityBatch instanceof LivingEntity) || (target = (LivingEntity)entityBatch) == ownerPlayer || !target.m_6084_()) continue;
                this.initiateAbilityAttack((LivingEntity)ownerPlayer, target, this.damage, AttackHurtTypes.NO_KB);
                target.m_20334_(0.0, 0.5, 0.0);
                CSEntityCapabilityProvider.get(target).ifPresent(data -> data.setFrostbound(200));
                target.m_216990_((SoundEvent)sound.getSecond());
            }
            this.shakeScreensForNearbyPlayers((Entity)ownerPlayer, this.m_9236_(), 15.0, 20, 15, 0.02f);
        }
        if (this.f_19797_ == 60) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CAST_LEVEL, (Object)0);
    }

    public void setCastLevel(int castLevel) {
        this.f_19804_.m_135381_(CAST_LEVEL, (Object)castLevel);
    }

    public int getCastLevel() {
        return (Integer)this.f_19804_.m_135370_(CAST_LEVEL);
    }
}

