/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.entity.projectile;

import com.aqutheseal.celestisynth.api.item.CSWeaponUtil;
import com.aqutheseal.celestisynth.common.capabilities.CSEntityCapabilityProvider;
import com.aqutheseal.celestisynth.common.entity.mob.misc.RainfallTurret;
import com.aqutheseal.celestisynth.common.entity.skillcast.SkillCastRainfallRain;
import com.aqutheseal.celestisynth.common.item.weapons.RainfallSerenityItem;
import com.aqutheseal.celestisynth.common.registry.CSEntityTypes;
import com.aqutheseal.celestisynth.common.registry.CSItems;
import com.aqutheseal.celestisynth.common.registry.CSParticleTypes;
import com.aqutheseal.celestisynth.common.registry.CSSoundEvents;
import com.aqutheseal.celestisynth.util.ParticleUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.joml.Vector3f;

public class RainfallArrow
extends AbstractArrow
implements CSWeaponUtil {
    private static final EntityDataAccessor<Boolean> IS_STRONG = SynchedEntityData.m_135353_(RainfallArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_FLAMING = SynchedEntityData.m_135353_(RainfallArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Vector3f> ORIGIN = SynchedEntityData.m_135353_(RainfallArrow.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    private static final EntityDataAccessor<Boolean> SHOULD_IMBUE_QUASAR = SynchedEntityData.m_135353_(RainfallArrow.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final RainfallSerenityItem rawRainfallItem = (RainfallSerenityItem)CSItems.RAINFALL_SERENITY.get();
    public boolean isMultishot = false;
    public RainfallTurret turretSource = null;

    public RainfallArrow(EntityType<? extends RainfallArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public RainfallArrow(Level pLevel, double pX, double pY, double pZ) {
        super((EntityType)CSEntityTypes.RAINFALL_ARROW.get(), pX, pY, pZ, pLevel);
    }

    public RainfallArrow(Level pLevel, LivingEntity pShooter) {
        super((EntityType)CSEntityTypes.RAINFALL_ARROW.get(), pShooter, pLevel);
    }

    public RainfallArrow(AbstractArrow arrow) {
        this(arrow.m_9236_(), (LivingEntity)arrow.m_19749_());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 5) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void m_6686_(double pX, double pY, double pZ, float pVelocity, float pInaccuracy) {
        super.m_6686_(pX, pY, pZ, pVelocity, pInaccuracy);
        this.m_20256_(this.m_20184_().m_82490_(30.0));
    }

    public boolean m_20068_() {
        return true;
    }

    public void hitEffect(HitResult pResult, BlockPos hitPos) {
        if (this.isStrong()) {
            Object potentialTarget2;
            EntityHitResult ehr;
            if (pResult instanceof BlockHitResult || pResult instanceof EntityHitResult && (ehr = (EntityHitResult)pResult).m_82443_() instanceof LivingEntity) {
                for (Object potentialTarget2 : this.rawRainfallItem.iterateEntities(this.m_9236_(), this.rawRainfallItem.createAABB((Vec3i)hitPos, 4.0))) {
                    if (!(potentialTarget2 instanceof LivingEntity)) continue;
                    LivingEntity target = (LivingEntity)potentialTarget2;
                    if (potentialTarget2 == this.m_19749_()) continue;
                    if (this.isFlaming()) {
                        target.m_20254_(2);
                    }
                    target.m_6469_(this.m_269291_().m_269104_((Entity)this, this.m_19749_() != null ? this.m_19749_() : null), 2.0f);
                    target.f_19802_ = 0;
                }
            }
            if (pResult instanceof EntityHitResult && (potentialTarget2 = (ehr = (EntityHitResult)pResult).m_82443_()) instanceof LivingEntity) {
                Entity entity;
                LivingEntity target = (LivingEntity)potentialTarget2;
                this.m_36767_((byte)(this.m_36796_() + 1));
                if (this.turretSource != null) {
                    target.m_6703_((LivingEntity)this.turretSource);
                }
                CSEntityCapabilityProvider.get(target).ifPresent(data -> {
                    Entity patt5269$temp = this.m_19749_();
                    if (patt5269$temp instanceof LivingEntity) {
                        LivingEntity player = (LivingEntity)patt5269$temp;
                        if (data.getQuasarImbueSource() == player) {
                            SkillCastRainfallRain projectile = (SkillCastRainfallRain)((EntityType)CSEntityTypes.RAINFALL_RAIN.get()).m_20615_(player.m_9236_());
                            projectile.targetPos = new BlockPos((Vec3i)ehr.m_82443_().m_20183_());
                            projectile.setOwnerUUID(player.m_20148_());
                            projectile.m_6027_(ehr.m_82443_().m_20185_(), ehr.m_82443_().m_20186_() + 15.0, ehr.m_82443_().m_20189_());
                            projectile.baseDamage = this.m_36789_() * 0.25;
                            projectile.isMultishot = this.isMultishot;
                            player.m_9236_().m_7967_((Entity)projectile);
                        }
                    }
                });
                if (this.f_19796_.m_188503_(3) == 1) {
                    for (Entity imbueSource : this.rawRainfallItem.iterateEntities(this.m_9236_(), this.rawRainfallItem.createAABB((Vec3i)hitPos, 24.0))) {
                        if (!(imbueSource instanceof LivingEntity)) continue;
                        LivingEntity livingSource = (LivingEntity)imbueSource;
                        CSEntityCapabilityProvider.get(livingSource).ifPresent(data -> {
                            Entity patt6441$temp;
                            if (imbueSource != ehr.m_82443_() && (patt6441$temp = this.m_19749_()) instanceof Player) {
                                Player player = (Player)patt6441$temp;
                                if (data.getQuasarImbueSource() == player) {
                                    ehr.m_82443_().f_19802_ = 0;
                                    if (!this.m_9236_().m_5776_()) {
                                        RainfallArrow rainfallArrow = new RainfallArrow(this.m_9236_(), (LivingEntity)player);
                                        rainfallArrow.m_5602_((Entity)player);
                                        rainfallArrow.m_20219_(imbueSource.m_20182_());
                                        rainfallArrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                                        rainfallArrow.setOrigin(imbueSource.m_146892_());
                                        rainfallArrow.m_36767_((byte)3);
                                        rainfallArrow.m_36781_(this.m_36789_() * 0.35);
                                        rainfallArrow.setImbueQuasar(false);
                                        double offsetHitResultY = ehr.m_82443_().m_20186_() + 1.5;
                                        double finalDistX = ehr.m_82443_().m_20185_() - imbueSource.m_20185_();
                                        double offsetDistY = offsetHitResultY - imbueSource.m_20186_() + 1.5;
                                        double finalDistZ = ehr.m_82443_().m_20189_() - imbueSource.m_20189_();
                                        rainfallArrow.m_6686_(finalDistX, offsetDistY, finalDistZ, 3.0f, 0.0f);
                                        this.m_9236_().m_7967_((Entity)rainfallArrow);
                                    }
                                    this.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)CSSoundEvents.LASER_SHOOT.get(), SoundSource.PLAYERS, 0.7f, 2.0f);
                                    data.clearQuasarImbue();
                                }
                            }
                        });
                    }
                }
                if ((entity = ehr.m_82443_()) instanceof LivingEntity) {
                    LivingEntity lt = (LivingEntity)entity;
                    CSEntityCapabilityProvider.get(lt).ifPresent(data -> {
                        Entity patt8603$temp;
                        if (this.isImbueQuasar() && (patt8603$temp = this.m_19749_()) instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)patt8603$temp;
                            data.setQuasarImbue(living, 200);
                        }
                    });
                }
            }
        }
        this.m_5496_(SoundEvents.f_11897_, 1.0f, 1.0f + this.f_19796_.m_188501_());
        int amount = 60;
        for (int e = 0; e < amount; ++e) {
            ParticleUtil.sendParticle(this.m_9236_(), (SimpleParticleType)CSParticleTypes.RAINFALL_ENERGY_SMALL.get(), Vec3.m_82512_((Vec3i)hitPos), Vec3.f_82478_.m_82520_(this.f_19796_.m_188583_() * 0.2, this.f_19796_.m_188583_() * 0.2, this.f_19796_.m_188583_() * 0.2));
        }
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        super.m_142687_(pReason);
    }

    public void markForLaser() {
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        if (this.m_9236_().m_8055_(pResult.m_82425_()).m_60838_((BlockGetter)this.m_9236_(), pResult.m_82425_())) {
            this.hitEffect((HitResult)pResult, pResult.m_82425_());
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        Entity entity = pResult.m_82443_();
        if (entity instanceof RainfallTurret) {
            RainfallTurret turret = (RainfallTurret)entity;
            if (turret.m_269323_() != this.m_19749_()) {
                this.hitEffect((HitResult)pResult, pResult.m_82443_().m_20183_());
            }
        } else {
            this.hitEffect((HitResult)pResult, pResult.m_82443_().m_20183_());
        }
        pResult.m_82443_().f_19802_ = 0;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    public boolean m_20147_() {
        return true;
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    protected float m_6882_() {
        return 1.0f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_STRONG, (Object)false);
        this.f_19804_.m_135372_(IS_FLAMING, (Object)false);
        this.f_19804_.m_135372_(ORIGIN, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
        this.f_19804_.m_135372_(SHOULD_IMBUE_QUASAR, (Object)true);
    }

    public boolean isStrong() {
        return (Boolean)this.f_19804_.m_135370_(IS_STRONG);
    }

    public void setStrong(boolean isStrong) {
        this.f_19804_.m_135381_(IS_STRONG, (Object)isStrong);
    }

    public boolean isFlaming() {
        return (Boolean)this.f_19804_.m_135370_(IS_FLAMING);
    }

    public void setFlaming(boolean isFlaming) {
        this.f_19804_.m_135381_(IS_FLAMING, (Object)isFlaming);
    }

    public Vec3 getOrigin() {
        return new Vec3((Vector3f)this.f_19804_.m_135370_(ORIGIN));
    }

    public void setOrigin(Vec3 origin) {
        this.f_19804_.m_135381_(ORIGIN, (Object)origin.m_252839_());
    }

    public boolean isImbueQuasar() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_IMBUE_QUASAR);
    }

    public void setImbueQuasar(boolean imbueAllow) {
        this.f_19804_.m_135381_(SHOULD_IMBUE_QUASAR, (Object)imbueAllow);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

