/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.entity.projectile;

import com.aqutheseal.celestisynth.api.item.AttackHurtTypes;
import com.aqutheseal.celestisynth.api.item.CSWeaponUtil;
import com.aqutheseal.celestisynth.common.registry.CSDamageSources;
import com.aqutheseal.celestisynth.common.registry.CSMobEffects;
import com.aqutheseal.celestisynth.common.registry.CSParticleTypes;
import com.aqutheseal.celestisynth.util.ParticleUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class KeresRend
extends ThrowableProjectile
implements GeoEntity,
CSWeaponUtil {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final List<LivingEntity> finishedAttacking = new ArrayList<LivingEntity>();
    public float baseDamage = 2.0f;

    public KeresRend(EntityType<? extends ThrowableProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public KeresRend(EntityType<? extends ThrowableProjectile> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        super(pEntityType, pX, pY, pZ, pLevel);
    }

    public KeresRend(EntityType<? extends ThrowableProjectile> pEntityType, LivingEntity pShooter, Level pLevel) {
        super(pEntityType, pShooter, pLevel);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_19749_() == null) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        this.m_20256_(this.m_20184_().m_82490_(1.1));
        AABB movedBB = this.m_20191_().m_82377_(0.0, 16.0, 0.0).m_82386_(0.0, 12.0, 0.0);
        for (double i = 0.0; i <= 12.0; i += 4.0) {
            this.checkWalls(movedBB.m_82383_(this.m_20184_().m_82541_().m_82490_(i)));
        }
        this.shakeScreensForNearbyPlayers((Entity)this, this.m_9236_(), 128.0, 40, 30, 0.04f);
        int i = 0;
        while ((double)i < 22.5) {
            Vec3 particleDir = Vec3.f_82478_.m_82520_((double)Mth.m_14031_((float)i), (double)Mth.m_14089_((float)i), 0.0).m_82490_(1.4);
            Vec3 rotated = particleDir.m_82496_(this.m_146909_() * ((float)Math.PI / 180)).m_82524_(this.m_146908_() * ((float)Math.PI / 180));
            ParticleUtil.sendParticle(this.m_9236_(), (SimpleParticleType)CSParticleTypes.KERES_OMEN.get(), this.m_20182_().m_82520_(0.0, 3.0, 0.0).m_82549_(this.m_20154_().m_82490_(2.0)), rotated);
            ++i;
        }
        Vec3 deltaBase = this.m_20184_().m_82541_();
        for (double i2 = 0.0; i2 <= 22.5; i2 += 1.0) {
            Vec3 rotRight = deltaBase.m_82490_(this.f_19796_.m_188583_() * 0.75).m_82524_(90.0f);
            ParticleUtil.sendParticle(this.m_9236_(), ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), rotRight.m_7096_(), this.f_19796_.m_188583_() * 0.75, rotRight.m_7094_());
            Vec3 rotLeft = deltaBase.m_82490_(this.f_19796_.m_188583_() * 0.75).m_82524_(-90.0f);
            ParticleUtil.sendParticle(this.m_9236_(), ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + 4.0, this.m_20189_(), rotLeft.m_7096_(), this.f_19796_.m_188583_() * 0.75, rotLeft.m_7094_());
        }
        if (this.f_19797_ >= 30) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> state.setAndContinue(RawAnimation.begin().thenLoop("animation.keres_rend.idle")))});
    }

    private void checkWalls(AABB pArea) {
        double iter = 0.0;
        int minY = Mth.m_14107_((double)pArea.f_82289_);
        int maxY = Mth.m_14107_((double)pArea.f_82292_);
        for (int yy = minY; yy <= maxY; ++yy) {
            pArea = pArea.m_82400_((iter += 0.25) / 6.0);
            int minX = Mth.m_14107_((double)pArea.f_82288_);
            int maxX = Mth.m_14107_((double)pArea.f_82291_);
            int minZ = Mth.m_14107_((double)pArea.f_82290_);
            int maxZ = Mth.m_14107_((double)pArea.f_82293_);
            for (int xx = minX; xx <= maxX; ++xx) {
                for (int zz = minZ; zz <= maxZ; ++zz) {
                    BlockPos blockpos = new BlockPos(xx, yy, zz);
                    BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                    if (blockstate.m_60795_() || blockstate.m_278721_() || blockstate.m_204336_(BlockTags.f_13069_) || blockpos.m_123341_() == this.m_19749_().m_146903_() && blockpos.m_123343_() == this.m_19749_().m_146907_()) continue;
                    if (!this.m_9236_().f_46443_) {
                        if (yy == minY) {
                            this.m_9236_().m_7731_(blockpos, Fluids.f_76195_.m_76145_().m_76188_(), 2);
                        } else {
                            this.m_9236_().m_46597_(blockpos, Blocks.f_50016_.m_49966_());
                        }
                    }
                    double xR = this.f_19796_.m_188583_() * 0.5;
                    double yR = this.f_19796_.m_188583_() * 0.5;
                    double zR = this.f_19796_.m_188583_() * 0.5;
                    ParticleUtil.sendParticle(this.m_9236_(), ParticleTypes.f_123747_, (double)xx + xR, (double)yy + yR, (double)zz + zR);
                    this.m_5496_(SoundEvents.f_11705_, 0.1f, 1.0f);
                }
            }
        }
        List<LivingEntity> targets = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82377_(4.0, 4.0, 4.0)).stream().filter(living -> living != this.m_19749_() && !this.finishedAttacking.contains(living)).toList();
        for (LivingEntity target : targets) {
            Entity maxZ = this.m_19749_();
            if (!(maxZ instanceof LivingEntity)) continue;
            LivingEntity owner = (LivingEntity)maxZ;
            target.m_7292_(new MobEffectInstance((MobEffect)CSMobEffects.CURSEBANE.get(), 250, 7));
            float damageCalculation = this.baseDamage + target.m_21233_() * (this.baseDamage * 0.015f);
            owner.m_5634_(damageCalculation / 8.0f);
            if (owner instanceof Player) {
                Player player = (Player)owner;
                player.m_36324_().m_38705_(player.m_36324_().m_38702_() + (int)((double)damageCalculation * 0.025));
                player.m_36324_().m_38717_(player.m_36324_().m_38722_() + (float)((int)((double)damageCalculation * 0.025)));
            }
            this.initiateAbilityAttack(owner, target, damageCalculation, CSDamageSources.instance(this.m_9236_()).erasure(owner), AttackHurtTypes.RAPID_NO_KB);
            if (target.m_21224_()) {
                target.m_142687_(Entity.RemovalReason.KILLED);
            }
            this.finishedAttacking.add(target);
        }
    }

    protected void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_20069_() {
        return false;
    }

    public boolean m_20068_() {
        return true;
    }

    protected void m_8097_() {
    }
}

