/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.entity.mob.natural;

import com.aqutheseal.celestisynth.common.entity.base.FixedMovesetEntity;
import com.aqutheseal.celestisynth.common.entity.base.MonolithSummonedEntity;
import com.aqutheseal.celestisynth.common.entity.goals.ActionStoppableMoveToTargetGoal;
import com.aqutheseal.celestisynth.common.entity.goals.AnimatedMeleeGoal;
import com.aqutheseal.celestisynth.common.entity.goals.traverser.TraverserJumpGoal;
import com.aqutheseal.celestisynth.common.entity.goals.traverser.TraverserStunnedGoal;
import com.aqutheseal.celestisynth.common.entity.mob.misc.StarMonolith;
import com.aqutheseal.celestisynth.common.entity.projectile.KeresSlash;
import com.aqutheseal.celestisynth.common.registry.CSEntityTypes;
import com.aqutheseal.celestisynth.common.registry.CSParticleTypes;
import com.aqutheseal.celestisynth.common.registry.CSSoundEvents;
import com.aqutheseal.celestisynth.util.ParticleUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Traverser
extends Monster
implements GeoEntity,
FixedMovesetEntity,
MonolithSummonedEntity {
    private static final EntityDataAccessor<Integer> ACTION = SynchedEntityData.m_135353_(Traverser.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ANIMATION_TICK = SynchedEntityData.m_135353_(Traverser.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public StarMonolith monolith;
    public static final int ACTION_MELEE = 1;
    public static final int ACTION_MELEE_1 = 2;
    public static final int ACTION_MELEE_2 = 3;
    public static final int ACTION_JUMP = 4;
    public static final int ACTION_STUNNED = 5;
    public static final int ACTION_SPAWNED = 6;
    public int nextAttack = 1;
    public boolean enableMeleeSlashing;

    public Traverser(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new TraverserStunnedGoal(this));
        this.f_21345_.m_25352_(2, new AnimatedMeleeGoal<Traverser>(this, 2, 20.0, 10.0, (double)this.m_20205_() + 2.5, mob -> this.nextAttack == 2 && mob.getAction() != 5, mob -> mob.getAction() != 5));
        this.f_21345_.m_25352_(2, new AnimatedMeleeGoal<Traverser>(this, 1, 20.0, 3.0, this.m_20205_() + 1.0f, mob -> this.nextAttack == 1 && mob.getAction() != 5, mob -> mob.getAction() != 5));
        this.f_21345_.m_25352_(2, new AnimatedMeleeGoal<Traverser>(this, 3, 20.0, 13.0, this.m_20205_() + 2.0f, mob -> this.nextAttack == 3 && mob.getAction() != 5, mob -> mob.getAction() != 5));
        this.f_21345_.m_25352_(3, (Goal)new TraverserJumpGoal(this));
        this.f_21345_.m_25352_(4, new ActionStoppableMoveToTargetGoal<Traverser>(this, 1.5, true, (double)(this.m_20205_() + 1.0f)));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false, entity -> !(entity instanceof Traverser) && !(entity instanceof StarMonolith)));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{Traverser.class}));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22277_, 128.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22284_, 15.0).m_22268_(Attributes.f_22280_, 1.0);
    }

    public double getAttackReachInBlocks() {
        return this.m_20205_() + 1.0f;
    }

    public void m_8119_() {
        int i;
        super.m_8119_();
        if (this.getAction() == 6) {
            if (this.f_19797_ >= 40) {
                this.resetAction();
            } else if (this.f_19797_ % 5 == 0) {
                i = 0;
                while ((double)i < 22.5) {
                    Vec3 particleDir = Vec3.f_82478_.m_82520_((double)Mth.m_14031_((float)i) * 1.2, 0.0, (double)Mth.m_14089_((float)i) * 1.2);
                    ParticleUtil.sendParticle(this.m_9236_(), (SimpleParticleType)CSParticleTypes.KERES_OMEN.get(), this.m_20182_().m_82549_(particleDir), new Vec3(0.0, 1.0, 0.0));
                    ++i;
                }
            }
        }
        if (this.getAction() == 1) {
            if (this.getAnimationTick() >= 2 && this.getAnimationTick() <= 8) {
                for (i = 0; i < 10; ++i) {
                    ParticleUtil.sendParticle(this.m_9236_(), (SimpleParticleType)CSParticleTypes.KERES_ASH.get(), this.m_20182_().m_82520_(this.f_19796_.m_188583_() * (double)0.1f, this.f_19796_.m_188583_() * (double)0.1f, this.f_19796_.m_188583_() * (double)0.1f), new Vec3(0.0, 0.2, 0.0));
                }
            }
            if (this.getAnimationTick() >= 10 && this.getAnimationTick() <= 15 && this.enableMeleeSlashing) {
                this.throwSlash();
            }
        }
    }

    public boolean m_7327_(Entity pEntity) {
        Vec3 retreatVector;
        boolean flag = super.m_7327_(pEntity);
        this.m_5496_((SoundEvent)CSSoundEvents.SLASH_WATER.get(), 0.2f, 1.2f);
        this.loopAttack();
        if (this.getAction() == 1) {
            retreatVector = this.m_20182_().m_82546_(pEntity.m_20182_()).m_82541_().m_82490_(2.0);
            this.m_20334_(retreatVector.m_7096_(), this.m_20184_().m_7098_(), retreatVector.m_7094_());
            this.m_5496_(SoundEvents.f_12558_, 0.6f, 0.5f);
            this.enableMeleeSlashing = flag;
        } else {
            this.enableMeleeSlashing = false;
        }
        if (flag) {
            this.m_5634_((float)((double)0.35f + this.f_19796_.m_188583_() * 0.25));
        }
        retreatVector = this.m_20182_().m_82546_(pEntity.m_20182_()).m_82541_().m_82490_(0.5 + this.f_19796_.m_188583_() * 0.2);
        if (this.getAction() == 3) {
            this.m_20334_(retreatVector.m_82548_().m_7096_(), this.m_20184_().m_7098_(), retreatVector.m_82548_().m_7094_());
        }
        if (this.getAction() == 2) {
            this.m_20334_(retreatVector.m_7096_(), this.m_20184_().m_7098_(), retreatVector.m_7094_());
        }
        return flag;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.getAction() == 6 && !pSource.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        if (this.getAction() == 1 && this.getAnimationTick() >= 5 && this.getAnimationTick() <= 20) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                server.m_213890_(null, (Entity)this, BuiltInRegistries.f_256894_.m_263177_((Object)((SoundEvent)CSSoundEvents.SWORD_CLASH.get())), SoundSource.NEUTRAL, 0.2f, 1.0f, server.f_46441_.m_188505_());
            }
            int i = 0;
            while ((double)i < 22.5) {
                Vec3 particleDir = Vec3.f_82478_.m_82520_((double)Mth.m_14031_((float)i), (double)Mth.m_14089_((float)i), 0.0).m_82490_(0.9);
                Vec3 rotated = particleDir.m_82496_(-this.m_146909_() * ((float)Math.PI / 180)).m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                ParticleUtil.sendParticle(this.m_9236_(), (SimpleParticleType)CSParticleTypes.KERES_OMEN.get(), this.m_20182_().m_82520_(0.0, 0.75, 0.0).m_82549_(this.m_20154_().m_82490_(2.0)), rotated);
                ++i;
            }
            pAmount *= 0.5f;
            this.resetAction();
        }
        boolean flag = super.m_6469_(pSource, pAmount);
        if (pSource.m_269533_(DamageTypeTags.f_268549_) || pSource.m_269533_(DamageTypeTags.f_268745_)) {
            flag = false;
        }
        if (flag) {
            this.loopAttack();
            if (this.hasNoAction()) {
                this.setAction(4);
            }
        }
        return flag;
    }

    protected void m_7355_(BlockPos pPos, BlockState pState) {
        super.m_7355_(pPos, pState);
        this.m_5496_((SoundEvent)CSSoundEvents.TRAVERSER_STEP.get(), 0.2f, 1.3f);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)CSSoundEvents.TRAVERSER_STEP.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)CSSoundEvents.TRAVERSER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CSSoundEvents.TRAVERSER_DEATH.get();
    }

    protected float m_6121_() {
        return 0.2f;
    }

    public float m_6100_() {
        return 1.3f + this.f_19796_.m_188501_() * 0.3f;
    }

    public boolean m_21525_() {
        return super.m_21525_() || this.getAction() == 6;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.m_5496_((SoundEvent)CSSoundEvents.SWORD_SWING_FIRE.get(), 0.2f, 1.0f);
    }

    public void loopAttack() {
        switch (this.getAction()) {
            case 1: {
                this.nextAttack = 2;
                break;
            }
            case 2: {
                this.nextAttack = 3;
                break;
            }
            case 3: {
                this.nextAttack = 1;
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 2, state -> {
            if (this.getAction() == 6) {
                state.setControllerSpeed(1.0f);
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.traverser.spawn"));
            }
            if (this.getAction() == 5) {
                state.setControllerSpeed(1.0f);
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.traverser.stunned"));
            }
            if (this.getAction() == 4) {
                state.setControllerSpeed(1.0f);
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.traverser.jump"));
            }
            if (this.getAction() == 3) {
                state.setControllerSpeed(1.0f);
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.traverser.melee3"));
            }
            if (this.getAction() == 2) {
                state.setControllerSpeed(1.0f);
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.traverser.melee2"));
            }
            if (this.getAction() == 1) {
                state.setControllerSpeed(1.0f);
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.traverser.melee"));
            }
            if (state.isMoving()) {
                state.setControllerSpeed(2.0f);
                return state.setAndContinue(RawAnimation.begin().thenLoop("animation.traverser.walk"));
            }
            state.setControllerSpeed(1.0f);
            return state.setAndContinue(RawAnimation.begin().thenLoop("animation.traverser.idle"));
        })});
    }

    public void throwSlash() {
        if (this.m_5448_() != null) {
            this.m_5496_((SoundEvent)CSSoundEvents.SLASH_WATER.get(), 0.2f, 1.0f);
            KeresSlash slash = new KeresSlash((EntityType<? extends ThrowableProjectile>)((EntityType)CSEntityTypes.KERES_SLASH.get()), (LivingEntity)this, this.m_9236_());
            slash.m_20219_(this.m_20182_().m_82520_(0.0, 0.5, 0.0));
            slash.baseDamage = 0.2f;
            slash.setRoll((float)(this.m_217043_().m_188583_() * 360.0));
            slash.m_6686_(this.m_5448_().m_20185_() - this.m_20185_(), this.m_5448_().m_20186_() - this.m_20186_(), this.m_5448_().m_20189_() - this.m_20189_(), 2.0f, 3.0f);
            this.m_9236_().m_7967_((Entity)slash);
        }
    }

    public void m_6667_(DamageSource pDamageSource) {
        super.m_6667_(pDamageSource);
        this.resetAction();
    }

    protected void m_6153_() {
        super.m_6153_();
        this.resetAction();
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("monolith")) {
            StarMonolith starMonolith;
            Entity entity = this.m_9236_().m_6815_(pCompound.m_128451_("monolith"));
            this.setMonolith(entity instanceof StarMonolith ? (starMonolith = (StarMonolith)entity) : null);
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("monolith", this.getMonolith() != null ? this.getMonolith().m_19879_() : 0);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void setAction(int action) {
        this.f_19804_.m_135381_(ACTION, (Object)action);
    }

    @Override
    public int getAction() {
        return (Integer)this.f_19804_.m_135370_(ACTION);
    }

    @Override
    public int getAnimationTick() {
        return (Integer)this.f_19804_.m_135370_(ANIMATION_TICK);
    }

    @Override
    public void setAnimationTick(int tick) {
        this.f_19804_.m_135381_(ANIMATION_TICK, (Object)tick);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ACTION, (Object)0);
        this.f_19804_.m_135372_(ANIMATION_TICK, (Object)0);
    }

    @Override
    public void setMonolith(@Nullable StarMonolith monolith) {
        this.monolith = monolith;
    }

    @Override
    @Nullable
    public StarMonolith getMonolith() {
        return this.monolith;
    }
}

