/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.entity.mob.misc;

import com.aqutheseal.celestisynth.common.entity.base.CSEffectEntity;
import com.aqutheseal.celestisynth.common.entity.base.SummonableEntity;
import com.aqutheseal.celestisynth.common.entity.goals.CSLookAroundGoal;
import com.aqutheseal.celestisynth.common.entity.goals.CSLookAtTargetGoal;
import com.aqutheseal.celestisynth.common.entity.goals.CSOwnerAttackGoal;
import com.aqutheseal.celestisynth.common.entity.goals.CSOwnerAttackedGoal;
import com.aqutheseal.celestisynth.common.entity.helper.CSVisualType;
import com.aqutheseal.celestisynth.common.entity.projectile.RainfallArrow;
import com.aqutheseal.celestisynth.common.registry.CSItems;
import com.aqutheseal.celestisynth.common.registry.CSParticleTypes;
import com.aqutheseal.celestisynth.common.registry.CSSoundEvents;
import com.aqutheseal.celestisynth.common.registry.CSVisualTypes;
import com.aqutheseal.celestisynth.util.EntityUtil;
import com.aqutheseal.celestisynth.util.ParticleUtil;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatListIterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RainfallTurret
extends SummonableEntity
implements GeoEntity {
    private static final EntityDataAccessor<Boolean> SHOOTING = SynchedEntityData.m_135353_(RainfallTurret.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> X_SYNC_ROT = SynchedEntityData.m_135353_(RainfallTurret.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<CompoundTag> ITEM_DATA = SynchedEntityData.m_135353_(RainfallTurret.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public int shootTime;

    public RainfallTurret(EntityType<? extends Mob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.setXSyncedRot(this.m_146909_());
        }
        this.m_5618_(0.0f);
        this.f_20884_ = 0.0f;
        this.tickShooting();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new CSLookAtTargetGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new CSLookAroundGoal(this, entity -> entity.m_5448_() == null));
        this.f_21346_.m_25352_(3, new CSOwnerAttackedGoal<RainfallTurret>(this));
        this.f_21346_.m_25352_(4, new CSOwnerAttackGoal<RainfallTurret>(this));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal<Monster>((Mob)this, Monster.class, 10, true, false, target -> EntityUtil.isValidTargetForOwnable(this, target)){

            protected AABB m_7255_(double pTargetDistance) {
                return this.f_26135_.m_20191_().m_82377_(pTargetDistance, pTargetDistance / 2.0, pTargetDistance);
            }
        });
        super.m_8099_();
    }

    public void tickShooting() {
        LivingEntity livingEntity;
        double enchantmentAdjustment = (double)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)this.createBowFromData()) * 3.25 - (double)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)this.createBowFromData()) * 3.5;
        int shootInterval = (int)(20.0 - Math.min(19.0, enchantmentAdjustment));
        if (this.m_5448_() != null && !this.m_213877_() && (livingEntity = this.m_269323_()) instanceof Player) {
            Player player = (Player)livingEntity;
            ++this.shootTime;
            if (this.shootTime > 0 && this.shootTime % shootInterval == 0) {
                this.f_19804_.m_135381_(SHOOTING, (Object)true);
                this.m_5496_((SoundEvent)CSSoundEvents.LASER_SHOOT.get(), 0.2f, 0.2f + this.f_19796_.m_188501_());
                CSEffectEntity.createInstance((LivingEntity)player, (Entity)this, (CSVisualType)CSVisualTypes.RAINFALL_SHOOT.get(), this.m_20154_().m_7096_() * 2.0, 0.5 + this.m_20154_().m_7098_() * 2.0, this.m_20154_().m_7094_() * 2.0);
                FloatArrayList angles = new FloatArrayList();
                angles.add(0.0f);
                int multishot = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)this.createBowFromData());
                if (multishot > 0) {
                    for (int i = 0; i < multishot + 1; ++i) {
                        angles.add((float)(10 * i));
                        angles.add((float)(-10 * i));
                    }
                }
                FloatListIterator floatListIterator = angles.iterator();
                while (floatListIterator.hasNext()) {
                    float angle = ((Float)floatListIterator.next()).floatValue();
                    if (this.m_9236_().f_46443_) continue;
                    RainfallArrow rainfallArrow = new RainfallArrow(this.m_9236_(), (LivingEntity)this);
                    Vec3 vec31 = this.m_20289_(1.0f);
                    Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(angle * ((float)Math.PI / 180)), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
                    Vec3 vec3 = this.m_20252_(1.0f);
                    Vector3f vector3f = vec3.m_252839_().rotate((Quaternionfc)quaternionf);
                    rainfallArrow.m_5602_((Entity)this);
                    rainfallArrow.turretSource = this;
                    rainfallArrow.m_20219_(this.m_20182_().m_82520_(0.0, 1.0, 0.0));
                    rainfallArrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    rainfallArrow.setOrigin(rainfallArrow.m_20182_().m_82520_(0.0, 0.5, 0.0));
                    rainfallArrow.m_36767_((byte)3);
                    rainfallArrow.m_6686_(vector3f.x(), vector3f.y(), vector3f.z(), 3.0f, 1.0f);
                    this.m_9236_().m_7967_((Entity)rainfallArrow);
                }
            }
        } else {
            this.shootTime = 0;
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOTING, (Object)false);
        this.f_19804_.m_135372_(X_SYNC_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ITEM_DATA, (Object)new CompoundTag());
    }

    public void setXSyncedRot(float value) {
        this.f_19804_.m_135381_(X_SYNC_ROT, (Object)Float.valueOf(value));
    }

    public float getXSyncedRot() {
        return ((Float)this.f_19804_.m_135370_(X_SYNC_ROT)).floatValue();
    }

    public void setItemData(CompoundTag tag) {
        this.f_19804_.m_135381_(ITEM_DATA, (Object)tag);
    }

    public CompoundTag getItemData() {
        return (CompoundTag)this.f_19804_.m_135370_(ITEM_DATA);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128365_("itemDataRF", (Tag)this.getItemData());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setItemData(pCompound.m_128469_("itemDataRF"));
    }

    protected InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (pPlayer == this.m_269323_() && pPlayer.m_6144_()) {
            pPlayer.m_36356_(this.createBowFromData());
            this.m_216990_(SoundEvents.f_12019_);
            for (int i = 0; i < 16; ++i) {
                ParticleUtil.sendParticle(this.m_9236_(), (SimpleParticleType)CSParticleTypes.RAINFALL_ENERGY_SMALL.get(), this.m_20182_().m_82520_(this.m_9236_().f_46441_.m_188583_() * 0.4, 0.0, this.m_9236_().f_46441_.m_188583_() * 0.4), Vec3.f_82478_.m_82520_(0.0, this.m_9236_().f_46441_.m_188500_() * 0.65, 0.0));
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public ItemStack createBowFromData() {
        ItemStack stack = new ItemStack((ItemLike)CSItems.RAINFALL_SERENITY.get());
        stack.deserializeNBT(this.getItemData());
        return stack;
    }

    protected void m_6153_() {
        this.destroy();
    }

    public void destroy() {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_5592_(), this.m_5720_(), 1.0f, 2.0f);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50334_.m_49966_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 50, (double)this.m_20205_(), (double)this.m_20206_(), (double)this.m_20205_(), 0.1);
            ItemEntity dataItem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.createBowFromData());
            dataItem.m_5997_(0.0, 0.3, 0.0);
            dataItem.m_32055_().m_41721_(dataItem.m_32055_().m_41776_() - 1);
            this.m_9236_().m_7967_((Entity)dataItem);
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        RainfallArrow arrow;
        Entity entity;
        if (!this.m_9236_().f_46443_) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50334_.m_49966_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 25, (double)this.m_20205_(), (double)this.m_20206_(), (double)this.m_20205_(), 0.05);
        }
        if ((entity = pSource.m_7640_()) instanceof RainfallArrow && (arrow = (RainfallArrow)entity).m_19749_() == this.m_269323_()) {
            return false;
        }
        entity = pSource.m_7639_();
        if (entity instanceof Player) {
            Player entity2 = (Player)entity;
            this.setOwner(entity2);
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> state.setAndContinue(RawAnimation.begin().thenLoop("animation.rainfall_turret.idle")))});
    }

    public boolean m_6109_() {
        return true;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22280_, 0.0);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_6673_(DamageSource source) {
        return super.m_6673_(source) || source == this.m_269291_().m_269063_() || source == this.m_269291_().m_269318_();
    }

    protected Vec3 m_7939_() {
        return new Vec3(0.0, (double)(this.m_20192_() - 1.0f), 0.0);
    }

    public void m_20256_(Vec3 motionIn) {
        super.m_20256_(Vec3.f_82478_.m_82520_(0.0, -0.2, 0.0));
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_5834_() {
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11925_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11708_;
    }
}

