/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.entity.helper;

import com.aqutheseal.celestisynth.Celestisynth;
import com.aqutheseal.celestisynth.common.entity.mob.misc.StarMonolith;
import com.aqutheseal.celestisynth.common.entity.mob.natural.Traverser;
import com.aqutheseal.celestisynth.common.registry.CSEntityTypes;
import com.aqutheseal.celestisynth.common.registry.CSParticleTypes;
import com.aqutheseal.celestisynth.common.registry.CSTags;
import com.aqutheseal.celestisynth.util.ParticleUtil;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.util.TriConsumer;

public enum MonolithRunes {
    NO_RUNE((ResourceLocation)null, 0, 0, 0, 0, MonolithRunes::noRuneTick, (TriConsumer<StarMonolith, BlockPos, ServerLevel>)((TriConsumer)MonolithRunes::noRuneConsume)),
    BLOOD_RUNE("blood", 400, 1, 10, 3, MonolithRunes::bloodRuneTick, (TriConsumer<StarMonolith, BlockPos, ServerLevel>)((TriConsumer)MonolithRunes::bloodRuneConsume)),
    AQUA_RUNE("aqua", 0, 0, 0, 0, MonolithRunes::noRuneTick, (TriConsumer<StarMonolith, BlockPos, ServerLevel>)((TriConsumer)MonolithRunes::noRuneConsume)),
    APOCALYPTIC_RUNE("apocalyptic", 500, 20, 10, Integer.MAX_VALUE, MonolithRunes::noRuneTick, (TriConsumer<StarMonolith, BlockPos, ServerLevel>)((TriConsumer)MonolithRunes::apocalypticRuneConsume));

    public static final HashMap<TagKey<Item>, MonolithRunes> ACTIVATORS_LIST;
    @Nullable
    public final ResourceLocation runeTexture;
    public final int summonInterval;
    public final int summonClusterSize;
    public final int summonRange;
    public final int summonLimit;
    public final BiConsumer<StarMonolith, Level> ambientTick;
    public final TriConsumer<StarMonolith, BlockPos, ServerLevel> summonAction;

    private MonolithRunes(ResourceLocation runeTexture, int summonInterval, int summonClusterSize, int summonRange, int summonLimit, BiConsumer<StarMonolith, Level> ambientTick, TriConsumer<StarMonolith, BlockPos, ServerLevel> summonAction) {
        this.runeTexture = runeTexture;
        this.summonInterval = summonInterval;
        this.summonClusterSize = summonClusterSize;
        this.summonRange = summonRange;
        this.summonLimit = summonLimit;
        this.ambientTick = ambientTick;
        this.summonAction = summonAction;
    }

    private MonolithRunes(String runeId, int summonInterval, int summonClusterSize, int summonRange, int summonLimit, BiConsumer<StarMonolith, Level> ambientTick, TriConsumer<StarMonolith, BlockPos, ServerLevel> summonAction) {
        this(Celestisynth.prefix("textures/entity/mob/star_monolith/runes/star_monolith_rune_" + runeId + ".png"), summonInterval, summonClusterSize, summonRange, summonLimit, ambientTick, summonAction);
    }

    public static void noRuneTick(StarMonolith monolith, Level level) {
    }

    public static void noRuneConsume(StarMonolith monolith, BlockPos summonPosition, ServerLevel level) {
    }

    public static void bloodRuneTick(StarMonolith monolith, Level level) {
        Vec3 rot = new Vec3(monolith.m_217043_().m_188583_(), monolith.m_217043_().m_188583_(), monolith.m_217043_().m_188583_());
        ParticleUtil.sendParticle(level, (SimpleParticleType)CSParticleTypes.KERES_OMEN.get(), monolith.m_20182_().m_82549_(rot).m_82520_(0.0, 1.0, 0.0), rot.m_82490_(0.1));
    }

    public static void bloodRuneConsume(StarMonolith monolith, BlockPos summonPosition, ServerLevel level) {
        Traverser traverser = (Traverser)((EntityType)CSEntityTypes.TRAVERSER.get()).m_20615_((Level)level);
        traverser.m_20035_(summonPosition, 0.0f, 0.0f);
        traverser.setMonolith(monolith);
        traverser.setAction(6);
        level.m_7967_((Entity)traverser);
        Vec3 from = monolith.m_20182_().m_82520_(0.0, 1.25, 0.0);
        Vec3 to = traverser.m_20182_();
        double distance = from.m_82554_(to);
        Vec3 direction = to.m_82546_(from).m_82541_();
        for (double i = 0.0; i <= distance; i += 0.2) {
            Vec3 particlePos = from.m_82549_(direction.m_82490_(i));
            ParticleUtil.sendParticles(level, (SimpleParticleType)CSParticleTypes.KERES_OMEN.get(), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0);
        }
    }

    public static void apocalypticRuneConsume(StarMonolith monolith, BlockPos summonPosition, ServerLevel level) {
        List<EntityType> hostilesList = List.of(EntityType.f_20501_, EntityType.f_20518_, EntityType.f_20493_, EntityType.f_20524_, EntityType.f_20497_);
        Mob chosenMob = (Mob)hostilesList.get(level.f_46441_.m_188503_(hostilesList.size())).m_20615_((Level)level);
        chosenMob.m_20035_(summonPosition, 0.0f, 0.0f);
        chosenMob.m_21051_(Attributes.f_22276_).m_22100_(1024.0);
        chosenMob.m_21153_(chosenMob.m_21233_());
        List<LivingEntity> entities = level.m_45976_(LivingEntity.class, monolith.m_20191_().m_82400_(128.0)).stream().filter(i -> i != monolith && !(i instanceof Player) && !hostilesList.contains(i.m_6095_())).toList();
        if (!entities.isEmpty()) {
            chosenMob.m_6710_(entities.get(monolith.m_217043_().m_188503_(entities.size())));
        }
        level.m_7967_((Entity)chosenMob);
    }

    static {
        ACTIVATORS_LIST = new HashMap();
        ACTIVATORS_LIST.put(CSTags.Items.BLOOD_RUNE_ACTIVATOR, BLOOD_RUNE);
    }
}

