/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.entity.base;

import com.aqutheseal.celestisynth.Celestisynth;
import com.aqutheseal.celestisynth.common.entity.helper.CSVisualType;
import com.aqutheseal.celestisynth.common.registry.CSEntityTypes;
import com.aqutheseal.celestisynth.common.registry.CSVisualTypes;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.RegistryObject;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CSEffectEntity
extends Entity
implements GeoEntity {
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(CSEffectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<String> VISUAL_ID = SynchedEntityData.m_135353_(CSEffectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> ANIMATION_ID = SynchedEntityData.m_135353_(CSEffectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> FRAME_LEVEL = SynchedEntityData.m_135353_(CSEffectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SET_ROT_X = SynchedEntityData.m_135353_(CSEffectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SET_ROT_Z = SynchedEntityData.m_135353_(CSEffectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> CUSTOMIZABLE_SIZE = SynchedEntityData.m_135353_(CSEffectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation DEFAULT_ANIMATION = RawAnimation.begin().thenLoop("animation.cs_effect.spin");
    private Entity toFollow;
    private int lifespan;
    private int frameTimer;

    public CSEffectEntity(EntityType<? extends CSEffectEntity> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
    }

    @Nullable
    public static CSEffectEntity getEffectInstance(LivingEntity owner, @Nullable Entity toFollow, CSVisualType visual, double offsetX, double offsetY, double offsetZ) {
        if (owner == null) {
            return null;
        }
        CSEffectEntity slash = (CSEffectEntity)((EntityType)CSEntityTypes.CS_EFFECT.get()).m_20615_(owner.m_9236_());
        slash.setVisualID(visual.getName());
        slash.setAnimationID(visual.getAnimation().getAnimName());
        if (toFollow != null) {
            slash.m_6027_(toFollow.m_20185_() + offsetX, toFollow.m_20186_() - 1.5 + offsetY, toFollow.m_20189_() + offsetZ);
        } else {
            slash.m_6027_(owner.m_20185_() + offsetX, owner.m_20186_() - 1.5 + offsetY, owner.m_20189_() + offsetZ);
        }
        slash.setOwnerUuid(owner.m_20148_());
        slash.setToFollow(toFollow);
        slash.setRandomRotation();
        slash.m_146926_(owner.m_146909_());
        slash.f_19860_ = slash.m_146909_();
        slash.m_146922_(owner.m_146908_());
        slash.f_19859_ = slash.m_146908_();
        slash.m_19915_(slash.m_146908_(), slash.m_146909_());
        return slash;
    }

    public void setRandomRotation() {
        int rotationX = this.f_19796_.m_188503_(360);
        int rotationZ = this.f_19796_.m_188503_(360);
        this.setRotationX(rotationX);
        this.setRotationZ(rotationZ);
    }

    public static void createInstance(LivingEntity owner, @Nullable Entity toFollow, CSVisualType effectTypes) {
        CSEffectEntity.createInstance(owner, toFollow, effectTypes, 0.0, 0.0, 0.0);
    }

    public static void createInstanceLockedPos(LivingEntity owner, @Nullable Entity toFollow, CSVisualType effectTypes, double x, double y, double z) {
        if (owner == null) {
            return;
        }
        CSEffectEntity slash = CSEffectEntity.getEffectInstance(owner, toFollow, effectTypes, x, y, z);
        slash.m_6027_(x, y, z);
        owner.m_9236_().m_7967_((Entity)slash);
    }

    public static void createInstance(LivingEntity owner, @Nullable Entity toFollow, CSVisualType effectTypes, double xOffset, double yOffset, double zOffset) {
        if (owner == null) {
            return;
        }
        CSEffectEntity slash = CSEffectEntity.getEffectInstance(owner, toFollow, effectTypes, xOffset, yOffset, zOffset);
        slash.setOwnerUuid(owner.m_20148_());
        slash.setToFollow(toFollow);
        owner.m_9236_().m_7967_((Entity)slash);
    }

    public boolean m_6109_() {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> {
            if (this.getAnimationID() != null && this.getVisualType().getAnimation() != null) {
                return state.setAndContinue(RawAnimation.begin().thenLoop(this.getAnimationID()));
            }
            return state.setAndContinue(DEFAULT_ANIMATION);
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public CSVisualType getVisualType() {
        if (this.getVisualID() != null && !this.getVisualID().equals("none")) {
            for (RegistryObject visual : CSVisualTypes.VISUALS.getEntries()) {
                if (!this.getVisualID().equals(((CSVisualType)visual.get()).getName())) continue;
                return (CSVisualType)visual.get();
            }
        }
        return this.getDefaultVisual();
    }

    public void setVisualType(CSVisualType getEffectType) {
        this.setVisualID(getEffectType.getName());
    }

    public String getVisualID() {
        return (String)this.f_19804_.m_135370_(VISUAL_ID);
    }

    public void setVisualID(String value) {
        this.f_19804_.m_135381_(VISUAL_ID, (Object)value);
    }

    public String getAnimationID() {
        return (String)this.f_19804_.m_135370_(ANIMATION_ID);
    }

    public void setAnimationID(String value) {
        this.f_19804_.m_135381_(ANIMATION_ID, (Object)value);
    }

    public int getFrameLevel() {
        return (Integer)this.f_19804_.m_135370_(FRAME_LEVEL);
    }

    public void setFrameLevel(int value) {
        this.f_19804_.m_135381_(FRAME_LEVEL, (Object)value);
    }

    public void setRotationX(int rotationX) {
        this.f_19804_.m_135381_(SET_ROT_X, (Object)rotationX);
    }

    public void setRotationZ(int rotationZ) {
        this.f_19804_.m_135381_(SET_ROT_Z, (Object)rotationZ);
    }

    public int getRotationX() {
        return (Integer)this.f_19804_.m_135370_(SET_ROT_X);
    }

    public int getRotationZ() {
        return (Integer)this.f_19804_.m_135370_(SET_ROT_Z);
    }

    public float getCustomizableSize() {
        return ((Float)this.f_19804_.m_135370_(CUSTOMIZABLE_SIZE)).floatValue();
    }

    public void setCustomizableSize(float size) {
        this.f_19804_.m_135381_(CUSTOMIZABLE_SIZE, (Object)Float.valueOf(size));
    }

    public void setOwnerUuid(@Nullable UUID ownerUuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(ownerUuid));
    }

    @Nullable
    public UUID getOwnerUuid() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public Entity getToFollow() {
        return this.toFollow;
    }

    public void setToFollow(Entity livingEntity) {
        this.toFollow = livingEntity;
    }

    public void setLifespan(int value) {
        this.lifespan = value;
    }

    public void m_8119_() {
        if (this.getOwnerUuid() == null) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            Celestisynth.LOGGER.debug("Removed CSEffect with no owner!");
        }
        ++this.frameTimer;
        if (this.frameTimer >= this.getVisualType().getFramesSpeed()) {
            this.setFrameLevel(this.getFrameLevel() == this.getVisualType().getFrames() ? 1 : this.getFrameLevel() + 1);
            this.frameTimer = 0;
        }
        if (this.toFollow != null) {
            if (this.getVisualType() == CSVisualTypes.AQUAFLORA_FLOWER_BIND.get()) {
                this.calculateCustomizableSize((float)((double)this.toFollow.m_20205_() - (double)this.toFollow.m_20205_() / 4.5), -this.getCustomizableSize());
            } else {
                this.m_6027_(this.toFollow.m_20185_(), this.m_20186_(), this.toFollow.m_20189_());
            }
        }
        ++this.lifespan;
        if (this.lifespan >= this.getVisualType().getAnimation().getLifespan()) {
            this.setLifespan(0);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        super.m_8119_();
    }

    public void calculateCustomizableSize(float size, double yOff) {
        this.m_146922_(this.toFollow.m_146908_());
        this.f_19859_ = this.m_146908_();
        this.m_19915_(this.m_146908_(), this.m_146909_());
        this.setCustomizableSize(size);
        this.m_6027_(this.toFollow.m_20185_(), this.toFollow.m_20186_() + yOff, this.toFollow.m_20189_());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(VISUAL_ID, (Object)"none");
        this.f_19804_.m_135372_(ANIMATION_ID, (Object)"none");
        this.f_19804_.m_135372_(FRAME_LEVEL, (Object)1);
        this.f_19804_.m_135372_(SET_ROT_X, (Object)0);
        this.f_19804_.m_135372_(SET_ROT_Z, (Object)0);
        this.f_19804_.m_135372_(CUSTOMIZABLE_SIZE, (Object)Float.valueOf(1.0f));
    }

    public void m_7378_(CompoundTag compoundNBT) {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void m_7380_(CompoundTag compoundNBT) {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public CSVisualType getDefaultVisual() {
        return (CSVisualType)CSVisualTypes.SOLARIS_BLITZ.get();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

