/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.compat.jei.recipecategory;

import com.aqutheseal.celestisynth.client.gui.starlitfactory.StarlitFactoryScreen;
import com.aqutheseal.celestisynth.common.compat.jei.CSCompatJEI;
import com.aqutheseal.celestisynth.common.compat.jei.drawable.StarlitFactoryDrawable;
import com.aqutheseal.celestisynth.common.recipe.StarlitFactoryRecipe;
import com.aqutheseal.celestisynth.common.registry.CSBlocks;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import software.bernie.geckolib.core.object.Color;

public class StarlitFactoryRecipeCategory
implements IRecipeCategory<StarlitFactoryRecipe> {
    private final IDrawable background = new StarlitFactoryDrawable();
    private final IDrawable icon;
    protected final IDrawableStatic staticForge;
    protected final IDrawableAnimated animatedForge;

    public StarlitFactoryRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)CSBlocks.STARLIT_FACTORY.get()));
        this.staticForge = guiHelper.createDrawable(StarlitFactoryScreen.FACTORY_GUI, 208, 0, 44, 75);
        this.animatedForge = guiHelper.createAnimatedDrawable(this.staticForge, 100, IDrawableAnimated.StartDirection.TOP, false);
    }

    public RecipeType<StarlitFactoryRecipe> getRecipeType() {
        return CSCompatJEI.STARLIT_FACTORY;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"container.celestisynth.starlit_factory");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(StarlitFactoryRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.animatedForge.draw(guiGraphics, 62, 3);
        MutableComponent experienceString = Component.m_237113_((String)(recipe.getForgeTime() / 20 + "s"));
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        float motion = Mth.m_14031_((float)((float)minecraft.f_91074_.f_19797_ * 0.2f)) * 1.0f;
        Color color = Color.ofRGBA((float)(0.75f + motion * 0.25f), (float)(0.75f + motion * 0.25f), (float)1.0f, (float)1.0f);
        fontRenderer.m_168645_(experienceString.m_7532_(), 7.0f, 5.0f, color.argbInt(), color.darker(5.0f).getColor(), guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, StarlitFactoryRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 8, 17).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 44, 17).addIngredients((Ingredient)recipe.m_7527_().get(1));
        builder.addSlot(RecipeIngredientRole.INPUT, 26, 53).addIngredients((Ingredient)recipe.m_7527_().get(2));
        builder.addSlot(RecipeIngredientRole.INPUT, 108, 17).addIngredients((Ingredient)recipe.m_7527_().get(3));
        builder.addSlot(RecipeIngredientRole.INPUT, 108, 35).addIngredients((Ingredient)recipe.m_7527_().get(4));
        builder.addSlot(RecipeIngredientRole.INPUT, 108, 53).addIngredients((Ingredient)recipe.m_7527_().get(5));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 34).addItemStack(recipe.getResult());
    }

    public boolean isHandled(StarlitFactoryRecipe recipe) {
        return true;
    }
}

