/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.capabilities;

import Shadow.relocated.capabilitysyncer.core.LivingEntityCapability;
import Shadow.relocated.capabilitysyncer.network.EntityCapabilityStatusPacket;
import Shadow.relocated.capabilitysyncer.network.SimpleEntityCapabilityStatusPacket;
import com.aqutheseal.celestisynth.common.capabilities.CSCapabilityHelper;
import com.aqutheseal.celestisynth.common.capabilities.CSEntityCapabilityProvider;
import com.aqutheseal.celestisynth.manager.CSNetworkManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.simple.SimpleChannel;

public class CSEntityCapability
extends LivingEntityCapability
implements CSCapabilityHelper {
    public static final String ID = "celestisynthEntityCapabilities";
    public static final String FROSTBOUND_ID = "cs.frostBound";
    public static final String TRUE_INVISIBILITY_ID = "cs.trueInvisibility";
    public static final String PHANTOM_TAG_SOURCE_ID = "cs.phantomTagSource";
    public static final String PHANTOM_TAG_TIME_ID = "cs.phantomTagTime";
    public static final String QUASAR_IMBUE_SOURCE_ID = "cs.quasarImbueSource";
    public static final String QUASAR_IMBUE_TIME_ID = "cs.quasarImbueTime";
    private int frostBound;
    private int trueInvisibility;
    private int bloodthirst;
    @Nullable
    private LivingEntity phantomTagSource;
    private int phantomTagTime;
    @Nullable
    private LivingEntity quasarImbueSource;
    private int quasarImbueTime;

    protected CSEntityCapability(LivingEntity entity) {
        super(entity);
    }

    public int getFrostbound() {
        return this.frostBound;
    }

    public void setFrostbound(int value) {
        if (this.frostBound < value) {
            this.frostBound = value;
            this.updateTracking();
        }
    }

    public void decreaseFrostbound(int value) {
        this.frostBound = Math.max(this.frostBound - value, 0);
        this.updateTracking();
    }

    public void decreaseFrostbound() {
        this.decreaseFrostbound(1);
    }

    public int getTrueInvisibility() {
        return this.trueInvisibility;
    }

    public void setTrueInvisibility(int value) {
        if (this.trueInvisibility < value) {
            this.trueInvisibility = value;
            this.updateTracking();
        }
    }

    public void decreaseTrueInvisibility(int value) {
        this.trueInvisibility = Math.max(this.trueInvisibility - value, 0);
        this.updateTracking();
    }

    public void decreaseTrueInvisibility() {
        this.decreaseTrueInvisibility(1);
    }

    public void setPhantomTag(@Nonnull LivingEntity source, int time) {
        this.phantomTagSource = source;
        this.updateTracking();
        this.phantomTagTime = time;
    }

    @Nullable
    public LivingEntity getPhantomTagSource() {
        return this.phantomTagSource;
    }

    public int getPhantomTagTime() {
        return this.phantomTagTime;
    }

    public void clearPhantomTag() {
        if (this.phantomTagSource != null) {
            this.phantomTagSource = null;
            this.updateTracking();
        }
    }

    public void decreasePhantomTagTime() {
        this.phantomTagTime = Math.max(this.phantomTagTime - 1, 0);
    }

    public void setQuasarImbue(@Nonnull LivingEntity source, int time) {
        this.quasarImbueSource = source;
        this.updateTracking();
        this.quasarImbueTime = time;
    }

    @Nullable
    public LivingEntity getQuasarImbueSource() {
        return this.quasarImbueSource;
    }

    public int getQuasarImbueTime() {
        return this.quasarImbueTime;
    }

    public void clearQuasarImbue() {
        if (this.quasarImbueSource != null) {
            this.quasarImbueSource = null;
            this.updateTracking();
        }
    }

    public void decreaseQuasarImbueTime() {
        if (this.quasarImbueTime > 0) {
            --this.quasarImbueTime;
        }
    }

    @Override
    public CompoundTag serializeNBT(boolean savingToDisk) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(FROSTBOUND_ID, this.frostBound);
        nbt.m_128405_(TRUE_INVISIBILITY_ID, this.trueInvisibility);
        nbt.m_128405_(PHANTOM_TAG_SOURCE_ID, this.phantomTagSource != null ? this.phantomTagSource.m_19879_() : 0);
        nbt.m_128405_(PHANTOM_TAG_TIME_ID, this.phantomTagTime);
        nbt.m_128405_(QUASAR_IMBUE_SOURCE_ID, this.quasarImbueSource != null ? this.quasarImbueSource.m_19879_() : 0);
        nbt.m_128405_(QUASAR_IMBUE_TIME_ID, this.quasarImbueTime);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt, boolean readingFromDisk) {
        if (nbt.m_128425_(FROSTBOUND_ID, 3)) {
            this.frostBound = nbt.m_128451_(FROSTBOUND_ID);
        }
        if (nbt.m_128425_(TRUE_INVISIBILITY_ID, 3)) {
            this.trueInvisibility = nbt.m_128451_(TRUE_INVISIBILITY_ID);
        }
        if (this.checkBoth(nbt, (byte)3, PHANTOM_TAG_SOURCE_ID, PHANTOM_TAG_TIME_ID)) {
            this.phantomTagSource = this.getLivingFromWorld(this.livingEntity.m_9236_(), nbt.m_128451_(PHANTOM_TAG_SOURCE_ID));
            this.phantomTagTime = nbt.m_128451_(PHANTOM_TAG_TIME_ID);
        }
        if (this.checkBoth(nbt, (byte)3, QUASAR_IMBUE_SOURCE_ID, QUASAR_IMBUE_TIME_ID)) {
            this.quasarImbueSource = this.getLivingFromWorld(this.livingEntity.m_9236_(), nbt.m_128451_(QUASAR_IMBUE_SOURCE_ID));
            this.quasarImbueTime = nbt.m_128451_(QUASAR_IMBUE_TIME_ID);
        }
    }

    @Override
    public EntityCapabilityStatusPacket createUpdatePacket() {
        return new SimpleEntityCapabilityStatusPacket(this.livingEntity.m_19879_(), CSEntityCapabilityProvider.CS_ENTITY_CAP_RL, this);
    }

    @Override
    public SimpleChannel getNetworkChannel() {
        return CSNetworkManager.INSTANCE;
    }
}

