/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.block;

import com.aqutheseal.celestisynth.client.gui.starlitfactory.StarlitFactoryMenu;
import com.aqutheseal.celestisynth.common.network.s2c.BlockEntitySetSlotPacket;
import com.aqutheseal.celestisynth.common.recipe.StarlitFactoryRecipe;
import com.aqutheseal.celestisynth.common.registry.CSBlockEntityTypes;
import com.aqutheseal.celestisynth.common.registry.CSItems;
import com.aqutheseal.celestisynth.common.registry.CSParticleTypes;
import com.aqutheseal.celestisynth.common.registry.CSRecipeTypes;
import com.aqutheseal.celestisynth.manager.CSNetworkManager;
import com.aqutheseal.celestisynth.util.ParticleUtil;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class StarlitFactoryBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
RecipeHolder,
StackedContentsCompatible,
GeoBlockEntity {
    private final RecipeType<StarlitFactoryRecipe> recipeType;
    protected NonNullList<ItemStack> containedItems = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
    int energyBurnTime;
    int energyAmount;
    int factoryForgeTime;
    int maxFactoryForgeTime;
    int isHoldingValidRecipe;
    int isResultSlotFilled;
    public final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int pIndex) {
            return switch (pIndex) {
                case 0 -> StarlitFactoryBlockEntity.this.energyBurnTime;
                case 1 -> StarlitFactoryBlockEntity.this.energyAmount;
                case 2 -> StarlitFactoryBlockEntity.this.factoryForgeTime;
                case 3 -> StarlitFactoryBlockEntity.this.maxFactoryForgeTime;
                case 4 -> StarlitFactoryBlockEntity.this.isHoldingValidRecipe;
                case 5 -> StarlitFactoryBlockEntity.this.isResultSlotFilled;
                default -> 0;
            };
        }

        public void m_8050_(int pIndex, int pValue) {
            switch (pIndex) {
                case 0: {
                    StarlitFactoryBlockEntity.this.energyBurnTime = pValue;
                    break;
                }
                case 1: {
                    StarlitFactoryBlockEntity.this.energyAmount = pValue;
                    break;
                }
                case 2: {
                    StarlitFactoryBlockEntity.this.factoryForgeTime = pValue;
                    break;
                }
                case 3: {
                    StarlitFactoryBlockEntity.this.maxFactoryForgeTime = pValue;
                    break;
                }
                case 4: {
                    StarlitFactoryBlockEntity.this.isHoldingValidRecipe = pValue;
                    break;
                }
                case 5: {
                    StarlitFactoryBlockEntity.this.isResultSlotFilled = pValue;
                }
            }
        }

        public int m_6499_() {
            return 6;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    private final RecipeManager.CachedCheck<Container, StarlitFactoryRecipe> quickCheck;
    int tickCount;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public StarlitFactoryBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)CSBlockEntityTypes.STARLIT_FACTORY_TILE.get(), pPos, pBlockState);
        this.recipeType = (RecipeType)CSRecipeTypes.STARLIT_FACTORY_TYPE.get();
        this.quickCheck = RecipeManager.m_220267_(this.recipeType);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "starlit_controller", 5, state -> PlayState.STOP).triggerableAnim("forging", RawAnimation.begin().thenPlay("animation.starlit_factory.forging"))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.celestisynth.starlit_factory");
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int pContainerId, Inventory pInventory) {
        return new StarlitFactoryMenu(pContainerId, pInventory, (Container)this, this.dataAccess);
    }

    public static Map<Item, Integer> getFuelMap() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        map.put(Items.f_151049_, 5);
        map.put((Item)CSItems.CELESTIAL_CORE.get(), 105);
        map.put((Item)CSItems.CELESTIAL_CORE_HEATED.get(), 120);
        map.put((Item)CSItems.CELESTIAL_DEBUGGER.get(), 1000);
        return map;
    }

    public void playSound(Level pLevel, BlockPos pPos, SoundEvent sound, float volume, float pitch) {
        pLevel.m_5594_(null, pPos, sound, SoundSource.BLOCKS, volume, pitch);
    }

    public void serverTick(Level pLevel, BlockPos pPos, BlockState pState) {
        StarlitFactoryRecipe recipe;
        ++this.tickCount;
        if (((ItemStack)this.containedItems.get(7)).m_41619_()) {
            CSNetworkManager.sendToAll(new BlockEntitySetSlotPacket(this.m_58899_(), 7, ItemStack.f_41583_));
        } else {
            CSNetworkManager.sendToAll(new BlockEntitySetSlotPacket(this.m_58899_(), 7, (ItemStack)this.containedItems.get(7)));
        }
        ItemStack fuel = (ItemStack)this.containedItems.get(6);
        if (this.energyAmount < 1000) {
            if (StarlitFactoryBlockEntity.getFuelMap().containsKey(fuel.m_41720_())) {
                int value = StarlitFactoryBlockEntity.getFuelMap().get(fuel.m_41720_());
                if (this.energyBurnTime < 100) {
                    ++this.energyBurnTime;
                } else if (this.energyBurnTime == 100) {
                    this.addEnergy(value);
                    fuel.m_41774_(1);
                    this.playSound(pLevel, pPos, SoundEvents.f_11736_, 1.0f, 1.2f);
                    this.energyBurnTime = 0;
                }
            } else {
                this.energyBurnTime = 0;
            }
        }
        if ((recipe = (StarlitFactoryRecipe)this.quickCheck.m_213657_((Container)this, pLevel).orElse(null)) == null) {
            this.isHoldingValidRecipe = 0;
            this.factoryForgeTime = 0;
            return;
        }
        if (this.isRecipeAvailableToForge(pLevel.m_9598_(), recipe)) {
            this.isHoldingValidRecipe = 1;
            if (this.isEnergyAvailable()) {
                if (this.factoryForgeTime < recipe.getForgeTime()) {
                    if (this.factoryForgeTime % 2 == 0) {
                        this.playSound(pLevel, pPos, SoundEvents.f_11981_, 1.0f, 0.5f);
                    }
                    if (this.factoryForgeTime % 20 == 0) {
                        this.playSound(pLevel, pPos, SoundEvents.f_12032_, 1.0f, (float)(0.8 + pLevel.f_46441_.m_188583_()));
                    }
                    ParticleUtil.sendParticle(pLevel, (SimpleParticleType)CSParticleTypes.RAINFALL_ENERGY_SMALL.get(), Vec3.m_82512_((Vec3i)pPos), Vec3.f_82478_.m_82520_(0.0, 1.0, 0.0));
                    ++this.factoryForgeTime;
                    this.addEnergy(-1);
                    this.triggerAnim("starlit_controller", "forging");
                } else if (this.factoryForgeTime == recipe.getForgeTime()) {
                    this.factoryForgeTime = 0;
                    this.playSound(pLevel, pPos, SoundEvents.f_11887_, 1.2f, 0.85f);
                    if (this.finishForging(pLevel.m_9598_(), recipe)) {
                        for (int i = 0; i < 45; ++i) {
                            ParticleUtil.sendParticle(pLevel, (SimpleParticleType)CSParticleTypes.RAINFALL_ENERGY_SMALL.get(), Vec3.m_82512_((Vec3i)pPos).m_82520_(0.0, 0.5, 0.0), Vec3.f_82478_.m_82520_((double)Mth.m_14031_((float)i) * 0.4, 0.0, (double)Mth.m_14089_((float)i) * 0.4));
                        }
                        this.m_6029_(recipe);
                    }
                }
            } else {
                this.factoryForgeTime = 0;
            }
        } else {
            this.isHoldingValidRecipe = 0;
            this.factoryForgeTime = 0;
        }
    }

    public boolean isRecipeAvailableToForge(RegistryAccess access, StarlitFactoryRecipe recipe) {
        if (recipe != null) {
            ItemStack recipeStack = recipe.m_5874_((Container)this, access);
            if (recipeStack.m_41619_()) {
                return false;
            }
            ItemStack result = (ItemStack)this.containedItems.get(7);
            this.maxFactoryForgeTime = recipe.getForgeTime();
            if (result.m_41619_()) {
                return true;
            }
            if (!ItemStack.m_41656_((ItemStack)result, (ItemStack)recipeStack)) {
                return false;
            }
            if (result.m_41613_() + recipeStack.m_41613_() <= this.m_6893_() && result.m_41613_() + recipeStack.m_41613_() <= result.m_41741_()) {
                return true;
            }
            return result.m_41613_() + recipeStack.m_41613_() <= recipeStack.m_41741_();
        }
        return false;
    }

    public boolean finishForging(RegistryAccess access, StarlitFactoryRecipe recipe) {
        if (recipe != null && this.isRecipeAvailableToForge(access, recipe)) {
            ItemStack resultStack = (ItemStack)this.containedItems.get(7);
            ItemStack formedResultItem = recipe.m_5874_((Container)this, access);
            if (resultStack.m_41619_()) {
                this.m_6836_(7, formedResultItem.m_41777_());
            } else if (resultStack.m_150930_(formedResultItem.m_41720_())) {
                resultStack.m_41769_(formedResultItem.m_41613_());
            }
            for (ItemStack ingredientStack : this.containedItems) {
                if (ingredientStack == this.containedItems.get(7) || ingredientStack == this.containedItems.get(6)) continue;
                ingredientStack.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    public void addEnergy(int value) {
        this.energyAmount = Mth.m_14045_((int)(this.energyAmount + value), (int)0, (int)1000);
    }

    private boolean isEnergyAvailable() {
        return this.energyAmount > 0;
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.containedItems = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)pTag, this.containedItems);
        this.factoryForgeTime = pTag.m_128451_("factoryForgeTime");
        this.energyAmount = pTag.m_128451_("energyAmount");
        this.energyBurnTime = pTag.m_128451_("energyBurnTime");
        this.maxFactoryForgeTime = pTag.m_128451_("maxFactoryForgeTime");
        CompoundTag compoundtag = pTag.m_128469_("RecipesUsed");
        for (String s : compoundtag.m_128431_()) {
            this.recipesUsed.put((Object)new ResourceLocation(s), compoundtag.m_128451_(s));
        }
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        ContainerHelper.m_18973_((CompoundTag)pTag, this.containedItems);
        pTag.m_128405_("factoryForgeTime", this.energyBurnTime);
        pTag.m_128405_("energyAmount", this.energyAmount);
        pTag.m_128405_("energyBurnTime", this.energyBurnTime);
        pTag.m_128405_("maxFactoryForgeTime", this.maxFactoryForgeTime);
        CompoundTag compoundtag = new CompoundTag();
        this.recipesUsed.forEach((resLoc, val) -> compoundtag.m_128405_(resLoc.toString(), val.intValue()));
        pTag.m_128365_("RecipesUsed", (Tag)compoundtag);
    }

    public int m_6643_() {
        return this.containedItems.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.containedItems) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int pSlot) {
        return (ItemStack)this.containedItems.get(pSlot);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        ItemStack flag = ContainerHelper.m_18969_(this.containedItems, (int)pSlot, (int)pAmount);
        this.update(pAmount);
        return flag;
    }

    public void update(int pAmount) {
        this.m_6596_();
        if (this.m_58904_() != null) {
            this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), pAmount);
        }
    }

    public ItemStack m_8016_(int pSlot) {
        ItemStack flag = ContainerHelper.m_18966_(this.containedItems, (int)pSlot);
        return flag;
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        ItemStack itemstack = (ItemStack)this.containedItems.get(pSlot);
        boolean flag = !pStack.m_41619_() && ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)pStack);
        this.containedItems.set(pSlot, (Object)pStack);
        if (pStack.m_41613_() > this.m_6893_()) {
            pStack.m_41764_(this.m_6893_());
        }
        if (!flag) {
            this.m_6596_();
        }
    }

    public boolean m_6542_(Player pPlayer) {
        return Container.m_272074_((BlockEntity)this, (Player)pPlayer);
    }

    public void m_6211_() {
        this.containedItems.clear();
    }

    public void m_6029_(@Nullable Recipe<?> pRecipe) {
        if (pRecipe != null) {
            ResourceLocation resourcelocation = pRecipe.m_6423_();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    @Nullable
    public Recipe<?> m_7928_() {
        return null;
    }

    public void m_5809_(StackedContents pContents) {
        for (ItemStack itemstack : this.containedItems) {
            pContents.m_36491_(itemstack);
        }
    }

    public int[] m_7071_(Direction pSide) {
        int[] nArray;
        if (pSide == Direction.DOWN) {
            return new int[]{6};
        }
        if (pSide == Direction.UP) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 7;
        } else {
            nArray = IntStream.range(0, 5).toArray();
        }
        return nArray;
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return pIndex != 7;
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return true;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }
}

