/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.attack.poltergeist;

import com.aqutheseal.celestisynth.api.animation.player.PlayerAnimationContainer;
import com.aqutheseal.celestisynth.api.item.AttackHurtTypes;
import com.aqutheseal.celestisynth.common.attack.base.WeaponAttackInstance;
import com.aqutheseal.celestisynth.common.capabilities.CSEntityCapabilityProvider;
import com.aqutheseal.celestisynth.common.entity.base.CSEffectEntity;
import com.aqutheseal.celestisynth.common.entity.helper.CSVisualType;
import com.aqutheseal.celestisynth.common.registry.CSPlayerAnimations;
import com.aqutheseal.celestisynth.common.registry.CSSoundEvents;
import com.aqutheseal.celestisynth.common.registry.CSVisualTypes;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;

public class PoltergeistBarrierCallAttack
extends WeaponAttackInstance {
    public PoltergeistBarrierCallAttack(Player player, ItemStack stack) {
        super(player, stack);
    }

    @Override
    public PlayerAnimationContainer getAnimation() {
        return (PlayerAnimationContainer)CSPlayerAnimations.ANIM_POLTERGEIST_RETREAT.get();
    }

    @Override
    public int getCooldown() {
        return 80;
    }

    @Override
    public int getAttackStopTime() {
        return 20;
    }

    @Override
    public boolean getCondition() {
        return this.player.m_6144_();
    }

    @Override
    public void startUsing() {
        double range = 4.0;
        for (Entity entityBatch : this.iterateEntities(this.level, this.createAABB((Vec3i)this.player.m_20183_().m_7918_((int)(this.calculateXLook((LivingEntity)this.player) * 2.0), 0, (int)(this.calculateZLook((LivingEntity)this.player) * 2.0)), range))) {
            LivingEntity target;
            if (entityBatch instanceof LivingEntity && (target = (LivingEntity)entityBatch) != this.player && target.m_6084_() && !this.player.m_7307_((Entity)target)) {
                this.attributeDependentAttack((LivingEntity)this.player, target, this.stack, 0.8f, AttackHurtTypes.REGULAR);
                target.m_5496_((SoundEvent)CSSoundEvents.SWORD_CLASH.get(), 0.25f, 0.5f);
                CSEntityCapabilityProvider.get(target).ifPresent(data -> data.setPhantomTag((LivingEntity)this.player, 200));
                continue;
            }
            if (!(entityBatch instanceof Projectile)) continue;
            entityBatch.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        CSEffectEntity.createInstance((LivingEntity)this.player, null, (CSVisualType)CSVisualTypes.POLTERGEIST_RETREAT.get(), this.calculateXLook((LivingEntity)this.player) * 2.0, 1.0, this.calculateZLook((LivingEntity)this.player) * 2.0);
        this.sendExpandingParticles(this.level, (ParticleType<?>)ParticleTypes.f_123746_, this.player.m_20183_(), 45, 0.5f);
        double deltaY = this.player.m_20096_() ? 3.0 : 0.9;
        this.player.m_20334_(this.calculateXLook((LivingEntity)this.player) * -0.7, deltaY, this.calculateZLook((LivingEntity)this.player) * -0.7);
        this.player.f_19864_ = true;
        this.player.m_5496_(SoundEvents.f_11889_, 1.0f, 1.5f);
        this.player.m_5496_(SoundEvents.f_11705_, 1.0f, 1.5f);
        this.useAndDamageItem(this.getStack(), this.level, (LivingEntity)this.player, 2);
    }

    @Override
    public void tickAttack() {
    }

    @Override
    public void stopUsing() {
    }
}

