/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.attack.keres;

import com.aqutheseal.celestisynth.api.animation.player.PlayerAnimationContainer;
import com.aqutheseal.celestisynth.common.attack.base.WeaponAttackInstance;
import com.aqutheseal.celestisynth.common.entity.skillcast.SkillCastKeresSlashWave;
import com.aqutheseal.celestisynth.common.registry.CSEntityTypes;
import com.aqutheseal.celestisynth.common.registry.CSPlayerAnimations;
import com.aqutheseal.celestisynth.common.registry.CSSoundEvents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;

public class KeresSlashAttack
extends WeaponAttackInstance {
    public KeresSlashAttack(Player player, ItemStack stack, int heldDuration) {
        super(player, stack, heldDuration);
    }

    @Override
    public PlayerAnimationContainer getAnimation() {
        return switch (this.level.f_46441_.m_188503_(3)) {
            default -> (PlayerAnimationContainer)CSPlayerAnimations.ANIM_KERES_SLASH.get();
            case 1 -> (PlayerAnimationContainer)CSPlayerAnimations.ANIM_KERES_SLASH_1.get();
            case 2 -> (PlayerAnimationContainer)CSPlayerAnimations.ANIM_KERES_SLASH_2.get();
        };
    }

    @Override
    public boolean sameAnimationForBothHands() {
        return true;
    }

    @Override
    public int getCooldown() {
        return 5;
    }

    @Override
    public int getAttackStopTime() {
        return 5;
    }

    @Override
    public boolean getCondition() {
        return !this.player.m_6144_() && this.heldDuration < 200;
    }

    @Override
    public void startUsing() {
        this.player.m_5496_((SoundEvent)CSSoundEvents.SLASH_WATER.get(), 0.1f, (float)(1.5 + this.player.m_217043_().m_188500_() * 0.5));
        if (!this.level.f_46443_) {
            SkillCastKeresSlashWave wave = (SkillCastKeresSlashWave)((EntityType)CSEntityTypes.KERES_SLASH_WAVE.get()).m_20615_(this.level);
            wave.setOwner(this.player);
            wave.m_20219_(this.player.m_20182_());
            wave.damage = this.calculateAttributeDependentDamage((LivingEntity)this.player, this.stack, 0.1f);
            wave.lifespan = this.heldDuration / 6 + this.level.f_46441_.m_188503_(3);
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)this.stack) > 0) {
                wave.hasMultishot = true;
            }
            this.level.m_7967_((Entity)wave);
        }
        Vec3 add = this.player.m_20184_().m_82541_().m_82490_(this.player.m_20096_() ? 2.0 : 1.25);
        this.player.m_20334_(add.m_7096_(), 0.0, add.m_7094_());
    }

    @Override
    public void tickAttack() {
    }

    @Override
    public void stopUsing() {
    }
}

