/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.attack.keres;

import com.aqutheseal.celestisynth.api.animation.player.PlayerAnimationContainer;
import com.aqutheseal.celestisynth.common.attack.base.WeaponAttackInstance;
import com.aqutheseal.celestisynth.common.entity.projectile.KeresRend;
import com.aqutheseal.celestisynth.common.registry.CSEntityTypes;
import com.aqutheseal.celestisynth.common.registry.CSPlayerAnimations;
import com.aqutheseal.celestisynth.common.registry.CSSoundEvents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import software.bernie.geckolib.core.object.Color;

public class KeresRendAttack
extends WeaponAttackInstance {
    public KeresRendAttack(Player player, ItemStack stack, int heldDuration) {
        super(player, stack, heldDuration);
    }

    @Override
    public PlayerAnimationContainer getAnimation() {
        return (PlayerAnimationContainer)CSPlayerAnimations.ANIM_KERES_REND.get();
    }

    @Override
    public int getCooldown() {
        return 100;
    }

    @Override
    public int getAttackStopTime() {
        return 40;
    }

    @Override
    public boolean getCondition() {
        return this.heldDuration >= 200;
    }

    @Override
    public void startUsing() {
        this.player.m_5496_((SoundEvent)CSSoundEvents.BASS_DROP.get(), 0.3f, 1.0f);
        this.chantMessage((Entity)this.player, "keres", 20, Color.WHITE.argbInt());
    }

    @Override
    public void tickAttack() {
        if (this.getTimerProgress() == 13) {
            this.player.m_5496_((SoundEvent)CSSoundEvents.STEP.get(), 0.3f, 0.5f);
            this.chantMessage((Entity)this.player, "keres1", 20, Color.ofRGB((int)233, (int)116, (int)81).argbInt());
        }
        if (this.getTimerProgress() == 22) {
            this.player.m_5496_((SoundEvent)CSSoundEvents.BASS_PULSE.get(), 0.75f, 1.0f);
        }
        if (this.getTimerProgress() == 25) {
            this.chantMessage((Entity)this.player, "keres2", 40, Color.RED.argbInt());
            if (!this.level.f_46443_) {
                Vec3 lookAngleNormalized = this.player.m_20154_().m_82541_();
                KeresRend rend = new KeresRend((EntityType<? extends ThrowableProjectile>)((EntityType)CSEntityTypes.KERES_REND.get()), (LivingEntity)this.player, this.level);
                rend.m_20219_(this.player.m_20182_().m_82520_(-lookAngleNormalized.m_7096_() * 9.0, -3.0, -lookAngleNormalized.m_7094_() * 9.0));
                Vec3 vec31 = this.player.m_20289_(1.0f);
                Quaternionf quaternionf = new Quaternionf().setAngleAxis(0.0, vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
                Vec3 vec3 = this.player.m_20252_(1.0f);
                Vector3f shootAngle = vec3.m_252839_().rotate((Quaternionfc)quaternionf);
                rend.baseDamage = this.calculateAttributeDependentDamage((LivingEntity)this.player, this.stack, 1.5f);
                rend.m_6686_(shootAngle.x, 0.0, shootAngle.z, 1.0f, 0.0f);
                this.level.m_7967_((Entity)rend);
            }
            this.flashScreen((Entity)this.player, 255, 15);
        }
    }

    @Override
    public void stopUsing() {
    }
}

