/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.attack.cresentia;

import com.aqutheseal.celestisynth.api.animation.player.PlayerAnimationContainer;
import com.aqutheseal.celestisynth.api.item.AttackHurtTypes;
import com.aqutheseal.celestisynth.api.item.CSWeaponUtil;
import com.aqutheseal.celestisynth.common.attack.base.WeaponAttackInstance;
import com.aqutheseal.celestisynth.common.entity.base.CSEffectEntity;
import com.aqutheseal.celestisynth.common.entity.helper.CSVisualType;
import com.aqutheseal.celestisynth.common.entity.projectile.CrescentiaDragon;
import com.aqutheseal.celestisynth.common.item.weapons.CrescentiaItem;
import com.aqutheseal.celestisynth.common.registry.CSPlayerAnimations;
import com.aqutheseal.celestisynth.common.registry.CSSoundEvents;
import com.aqutheseal.celestisynth.common.registry.CSVisualTypes;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.object.Color;

public class CrescentiaBarrageAttack
extends WeaponAttackInstance {
    public CrescentiaBarrageAttack(Player player, ItemStack stack) {
        super(player, stack);
    }

    @Override
    public PlayerAnimationContainer getAnimation() {
        return (PlayerAnimationContainer)CSPlayerAnimations.ANIM_CRESCENTIA_STRIKE.get();
    }

    @Override
    public int getCooldown() {
        return 100;
    }

    @Override
    public int getAttackStopTime() {
        return 70;
    }

    @Override
    public boolean getCondition() {
        return !this.player.m_6144_();
    }

    @Override
    public void startUsing() {
        this.useAndDamageItem(this.getStack(), this.level, (LivingEntity)this.player, 4);
        this.chantMessage((Entity)this.player, "crescentia", 30, Color.WHITE.argbInt());
    }

    @Override
    public void tickAttack() {
        List<CrescentiaDragon> dragons = this.level.m_45976_(CrescentiaDragon.class, this.player.m_20191_().m_82400_(128.0)).stream().filter(e -> e.m_19749_() == this.player).toList();
        for (CrescentiaDragon dragon : dragons) {
            Vec3 opp = this.player.m_20182_().m_82520_(0.0, 1.0, 0.0).m_82546_(dragon.m_20182_()).m_82541_().m_82490_(0.25);
            dragon.m_5997_(opp.m_7096_(), opp.m_7098_(), opp.m_7094_());
        }
        if (this.getTimerProgress() == 15) {
            this.player.m_5496_((SoundEvent)CSSoundEvents.WHIRLWIND.get(), 0.35f, 0.5f + this.level.f_46441_.m_188501_());
            this.chantMessage((Entity)this.player, "crescentia1", 20, Color.MAGENTA.argbInt());
        }
        if (this.getTimerProgress() >= 15 && this.getTimerProgress() <= 60) {
            double range = 6.0;
            List entities = this.level.m_45976_(Entity.class, this.player.m_20191_().m_82377_(range, range, range).m_82386_(this.calculateXLook((LivingEntity)this.player), 0.0, this.calculateZLook((LivingEntity)this.player)));
            for (Entity entityBatch : entities) {
                LivingEntity target;
                if (entityBatch instanceof LivingEntity && (target = (LivingEntity)entityBatch) != this.player && target.m_6084_() && !this.player.m_7307_((Entity)target) && target.m_20280_((Entity)this.player) <= range * range) {
                    this.attributeDependentAttack((LivingEntity)this.player, target, this.stack, 0.07f, AttackHurtTypes.RAPID);
                    target.m_7292_(CSWeaponUtil.nonVisiblePotionEffect(MobEffects.f_19597_, 20, 2));
                }
                if (!(entityBatch instanceof Projectile)) continue;
                Projectile projectile = (Projectile)entityBatch;
                CrescentiaItem.createCrescentiaFirework(this.getStack(), this.level, this.player, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), true);
                this.player.m_5496_(SoundEvents.f_11932_, 1.0f, 1.0f);
                projectile.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (this.getTimerProgress() % 30 == 0) {
                this.player.m_5496_((SoundEvent)CSSoundEvents.WHIRLWIND.get(), 0.15f, 1.0f + (float)(this.player.m_217043_().m_188583_() * 0.25));
            }
            if (this.getTimerProgress() % 5 == 0) {
                if (this.level.f_46441_.m_188499_()) {
                    CSEffectEntity.createInstance((LivingEntity)this.player, null, (CSVisualType)CSVisualTypes.CRESCENTIA_STRIKE.get(), this.calculateXLook((LivingEntity)this.player), -0.3, this.calculateZLook((LivingEntity)this.player));
                } else {
                    CSEffectEntity.createInstance((LivingEntity)this.player, null, (CSVisualType)CSVisualTypes.CRESCENTIA_STRIKE_INVERTED.get(), this.calculateXLook((LivingEntity)this.player), -0.3, this.calculateZLook((LivingEntity)this.player));
                }
                CrescentiaBarrageAttack.playRandomBladeSound((Entity)this.player, BASE_WEAPON_EFFECTS.length);
            }
            if (this.getTimerProgress() % 2 == 0) {
                CSEffectEntity.createInstance((LivingEntity)this.player, null, (CSVisualType)CSVisualTypes.SOLARIS_AIR_LARGE.get(), 0.0, -1.0, 0.0);
                float offX = this.level.f_46441_.m_188501_() * 16.0f - 8.0f;
                float offY = this.level.f_46441_.m_188501_() * 16.0f - 8.0f;
                float offZ = this.level.f_46441_.m_188501_() * 16.0f - 8.0f;
                CrescentiaItem.createCrescentiaFirework(this.getStack(), this.level, this.player, this.player.m_20185_() + (double)offX, this.player.m_20186_() + (double)offY, this.player.m_20189_() + (double)offZ, false);
                if (this.level.f_46441_.m_188499_()) {
                    CrescentiaItem.createCrescentiaFirework(this.getStack(), this.level, this.player, this.player.m_20185_() + (double)offZ, this.player.m_20186_() + (double)offX, this.player.m_20189_() + (double)offY, false);
                }
            }
        }
    }

    @Override
    public void stopUsing() {
    }
}

