/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.attack.breezebreaker;

import com.aqutheseal.celestisynth.api.animation.player.PlayerAnimationContainer;
import com.aqutheseal.celestisynth.api.item.AttackHurtTypes;
import com.aqutheseal.celestisynth.api.item.CSWeaponUtil;
import com.aqutheseal.celestisynth.common.attack.breezebreaker.BreezebreakerAttack;
import com.aqutheseal.celestisynth.common.entity.base.CSEffectEntity;
import com.aqutheseal.celestisynth.common.entity.helper.CSVisualType;
import com.aqutheseal.celestisynth.common.registry.CSPlayerAnimations;
import com.aqutheseal.celestisynth.common.registry.CSSoundEvents;
import com.aqutheseal.celestisynth.common.registry.CSVisualTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class BreezebreakerWindRoarAttack
extends BreezebreakerAttack {
    public BreezebreakerWindRoarAttack(Player player, ItemStack stack, int heldDuration) {
        super(player, stack, heldDuration);
    }

    @Override
    public PlayerAnimationContainer getAnimation() {
        return (PlayerAnimationContainer)CSPlayerAnimations.ANIM_BREEZEBREAKER_SPRINT_ATTACK.get();
    }

    @Override
    public int getCooldown() {
        return this.buffStateModified(15);
    }

    @Override
    public int getAttackStopTime() {
        return 20;
    }

    @Override
    public boolean getCondition() {
        return this.player.m_20142_();
    }

    @Override
    public void startUsing() {
        super.startUsing();
        this.useAndDamageItem(this.stack, this.level, (LivingEntity)this.player, 5);
    }

    @Override
    public void tickAttack() {
        if (this.getTimerProgress() == 10) {
            this.sendExpandingParticles(this.level, (ParticleType<?>)ParticleTypes.f_123777_, this.player.m_20183_(), 45, 0.01f);
            for (LivingEntity target : this.getEntitiesInLine(this.player, 10.0)) {
                if (target == this.player) continue;
                double targetDist = target.m_20270_((Entity)this.player);
                this.attributeDependentAttack((LivingEntity)this.player, target, this.stack, 2.0f + (float)targetDist * 0.075f, AttackHurtTypes.NO_KB);
                target.m_7292_(CSWeaponUtil.nonVisiblePotionEffect(MobEffects.f_19613_, 60, 2));
                target.m_7292_(CSWeaponUtil.nonVisiblePotionEffect(MobEffects.f_19597_, 60, 2));
                this.sendExpandingParticles(this.level, (ParticleType<?>)ParticleTypes.f_123815_, this.player.m_20183_().m_7494_(), 45, 0.2f);
            }
            double speed = 7.0;
            float distii = 0.0f;
            while ((double)distii < speed) {
                BlockPos newPos = new BlockPos((int)(this.player.m_20185_() + this.calculateXLook((LivingEntity)this.player) * (double)distii), (int)this.player.m_20186_(), (int)(this.player.m_20189_() + this.calculateZLook((LivingEntity)this.player) * (double)distii));
                if (!this.level.m_46859_(newPos)) {
                    speed = distii;
                    break;
                }
                distii += 0.25f;
            }
            Vec3 delta = new Vec3(this.calculateXLook((LivingEntity)this.player) * speed, 0.0, this.calculateZLook((LivingEntity)this.player) * speed);
            this.player.m_6027_(this.player.m_20185_() + this.calculateXLook((LivingEntity)this.player) * speed, this.player.m_20186_(), this.player.m_20189_() + this.calculateZLook((LivingEntity)this.player) * speed);
            double[] multipliers = new double[]{2.0, 1.5, 1.0, 0.5, 0.0};
            CSVisualType[] effectTypes = new CSVisualType[]{(CSVisualType)CSVisualTypes.BREEZEBREAKER_DASH.get(), (CSVisualType)CSVisualTypes.BREEZEBREAKER_DASH_2.get(), (CSVisualType)CSVisualTypes.BREEZEBREAKER_DASH_3.get(), (CSVisualType)CSVisualTypes.BREEZEBREAKER_DASH_3.get(), (CSVisualType)CSVisualTypes.BREEZEBREAKER_DASH_3.get()};
            for (int i = 0; i < multipliers.length; ++i) {
                boolean yOffset = i > 1;
                CSEffectEntity.createInstance((LivingEntity)this.player, null, effectTypes[i], delta.m_7096_() * multipliers[i], (double)yOffset, delta.m_7094_() * multipliers[i]);
            }
            this.player.m_5496_(SoundEvents.f_11913_, 1.0f, 1.5f);
            this.player.m_5496_((SoundEvent)CSSoundEvents.IMPACT_HIT.get(), 1.0f, 1.0f);
            this.player.m_5496_((SoundEvent)CSSoundEvents.STEP.get(), 1.0f, 1.0f);
        }
    }

    @Override
    public void stopUsing() {
    }
}

