/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.attack.breezebreaker;

import com.aqutheseal.celestisynth.api.animation.player.PlayerAnimationContainer;
import com.aqutheseal.celestisynth.common.attack.breezebreaker.BreezebreakerAttack;
import com.aqutheseal.celestisynth.common.entity.skillcast.SkillCastBreezebreakerTornado;
import com.aqutheseal.celestisynth.common.registry.CSEntityTypes;
import com.aqutheseal.celestisynth.common.registry.CSPlayerAnimations;
import com.aqutheseal.celestisynth.common.registry.CSSoundEvents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class BreezebreakerWhirlwindAttack
extends BreezebreakerAttack {
    public BreezebreakerWhirlwindAttack(Player player, ItemStack stack, int heldDuration) {
        super(player, stack, heldDuration);
    }

    @Override
    public PlayerAnimationContainer getAnimation() {
        if (this.player.m_21205_() == this.stack && this.player.m_21206_() != this.stack) {
            return (PlayerAnimationContainer)CSPlayerAnimations.ANIM_BREEZEBREAKER_SHIFT_RIGHT.get();
        }
        if (this.player.m_21206_() == this.stack && this.player.m_21205_() != this.stack) {
            return (PlayerAnimationContainer)CSPlayerAnimations.ANIM_BREEZEBREAKER_SHIFT_LEFT.get();
        }
        if (this.player.m_21206_() == this.stack && this.player.m_21205_() == this.stack) {
            boolean shouldShiftRight = this.player.m_217043_().m_188499_();
            return shouldShiftRight ? (PlayerAnimationContainer)CSPlayerAnimations.ANIM_BREEZEBREAKER_SHIFT_RIGHT.get() : (PlayerAnimationContainer)CSPlayerAnimations.ANIM_BREEZEBREAKER_SHIFT_LEFT.get();
        }
        return (PlayerAnimationContainer)CSPlayerAnimations.CLEAR.get();
    }

    @Override
    public void startUsing() {
        super.startUsing();
        this.useAndDamageItem(this.stack, this.level, (LivingEntity)this.player, 3);
    }

    @Override
    public int getCooldown() {
        return this.buffStateModified(35);
    }

    @Override
    public int getAttackStopTime() {
        return 20;
    }

    @Override
    public boolean getCondition() {
        return this.player.m_6047_();
    }

    @Override
    public void tickAttack() {
        if (this.getTimerProgress() == 10) {
            this.player.m_216990_((SoundEvent)CSSoundEvents.WIND_STRIKE.get());
            this.player.m_216990_((SoundEvent)CSSoundEvents.WHIRLWIND.get());
            if (!this.level.m_5776_()) {
                SkillCastBreezebreakerTornado tornadoSkillCast = (SkillCastBreezebreakerTornado)((EntityType)CSEntityTypes.BREEZEBREAKER_TORNADO.get()).m_20615_(this.level);
                tornadoSkillCast.setOwnerUUID(this.player.m_20148_());
                tornadoSkillCast.setAngleX((float)this.calculateXLook((LivingEntity)this.player));
                tornadoSkillCast.setAngleY((float)this.calculateYLook((LivingEntity)this.player));
                tornadoSkillCast.setAngleZ((float)this.calculateZLook((LivingEntity)this.player));
                tornadoSkillCast.setAddAngleX((float)this.calculateXLook((LivingEntity)this.player));
                tornadoSkillCast.setAddAngleY((float)this.calculateYLook((LivingEntity)this.player));
                tornadoSkillCast.setAddAngleZ((float)this.calculateZLook((LivingEntity)this.player));
                tornadoSkillCast.m_6027_(this.player.m_20185_(), this.player.m_20186_() + 1.0, this.player.m_20189_());
                tornadoSkillCast.damage = this.calculateAttributeDependentDamage((LivingEntity)this.player, this.stack, 0.1f);
                this.level.m_7967_((Entity)tornadoSkillCast);
            }
        }
    }

    @Override
    public void stopUsing() {
    }
}

