/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.attack.aquaflora;

import com.aqutheseal.celestisynth.api.animation.player.PlayerAnimationContainer;
import com.aqutheseal.celestisynth.api.item.AttackHurtTypes;
import com.aqutheseal.celestisynth.common.attack.aquaflora.AquafloraAttack;
import com.aqutheseal.celestisynth.common.entity.base.CSEffectEntity;
import com.aqutheseal.celestisynth.common.entity.helper.CSVisualType;
import com.aqutheseal.celestisynth.common.entity.skillcast.SkillCastAquafloraCamera;
import com.aqutheseal.celestisynth.common.item.weapons.AquafloraItem;
import com.aqutheseal.celestisynth.common.registry.CSEntityTypes;
import com.aqutheseal.celestisynth.common.registry.CSPlayerAnimations;
import com.aqutheseal.celestisynth.common.registry.CSSoundEvents;
import com.aqutheseal.celestisynth.common.registry.CSVisualTypes;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class AquafloraSlashFrenzyAttack
extends AquafloraAttack {
    public static final String ATTACK_ONGOING = "cs.atkOngoing";
    public static final String INITIAL_PERSPECTIVE = "cs.initPerspective";
    public static final String INITIAL_VIEW_ANGLE = "cs.initViewAngle";

    public AquafloraSlashFrenzyAttack(Player player, ItemStack stack, int heldDuration) {
        super(player, stack, heldDuration);
    }

    @Override
    public PlayerAnimationContainer getAnimation() {
        return (PlayerAnimationContainer)CSPlayerAnimations.ANIM_AQUAFLORA_ASSASSINATE.get();
    }

    @Override
    public int getCooldown() {
        return 200;
    }

    @Override
    public int getAttackStopTime() {
        return 120;
    }

    @Override
    public boolean getCondition() {
        return this.getTagController().m_128471_("cs.checkPassiveIfBlooming") && !this.player.m_6047_();
    }

    @Override
    public void startUsing() {
        this.getTagController().m_128379_(ATTACK_ONGOING, true);
        this.getTagController().m_128350_(INITIAL_VIEW_ANGLE, this.player.m_146909_());
        if (!this.level.f_46443_) {
            SkillCastAquafloraCamera camera = (SkillCastAquafloraCamera)((EntityType)CSEntityTypes.AQUAFLORA_CAMERA.get()).m_20615_(this.level);
            camera.m_5602_((Entity)this.player);
            camera.m_146926_(-180.0f);
            camera.m_20219_(this.player.m_146892_().m_82520_(0.0, 15.0, 0.0));
            this.level.m_7967_((Entity)camera);
            ((ServerPlayer)this.player).f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)camera));
        }
    }

    @Override
    public void tickAttack() {
        this.setCameraAngle(this.player, 1);
        if (this.getTimerProgress() >= 15 && this.getTimerProgress() % (this.checkDualWield(this.player, AquafloraItem.class) ? 4 : 7) == 0) {
            LivingEntity target;
            Predicate<Entity> filter = e -> {
                LivingEntity le;
                return e != this.player && e instanceof LivingEntity && (this.player.m_142582_((Entity)(le = (LivingEntity)e)) || le.m_142582_((Entity)this.player)) && le.m_6084_() && !this.player.m_7307_((Entity)le);
            };
            List<LivingEntity> entities = this.iterateEntities(this.level, this.createAABB((Vec3i)this.player.m_20183_(), 12.0)).stream().filter(filter).map(LivingEntity.class::cast).toList();
            LivingEntity livingEntity = target = !entities.isEmpty() ? entities.get(this.level.f_46441_.m_188503_(entities.size())) : null;
            if (target == this.player || target == null) {
                this.player.m_5661_((Component)Component.m_237115_((String)"item.celestisynth.aquaflora.skill_3.notice"), true);
                this.player.m_5496_((SoundEvent)CSSoundEvents.BLING.get(), 0.25f, 1.5f);
                CSEffectEntity.createInstance((LivingEntity)this.player, null, (CSVisualType)CSVisualTypes.AQUAFLORA_DASH.get(), 0.0, 0.55, 0.0);
                this.baseStop();
                return;
            }
            double offsetX = -4 + this.level.f_46441_.m_188503_(8);
            double offsetZ = -4 + this.level.f_46441_.m_188503_(8);
            if (this.level.m_5776_()) {
                double dx = target.m_20185_() - (this.player.m_20185_() + offsetX);
                double dz = target.m_20189_() - (this.player.m_20189_() + offsetZ);
                double yaw = -Math.atan2(dx, dz);
                this.player.m_146922_((float)(yaw += (double)((yaw *= 57.29577951308232) < 0.0 ? 360 : 0)));
            }
            CSEffectEntity.createInstance((LivingEntity)this.player, null, (CSVisualType)CSVisualTypes.AQUAFLORA_DASH.get(), 0.0, 0.55, 0.0);
            BlockPos toPos = target.m_20183_().m_7918_((int)offsetX, 1, (int)offsetZ);
            this.player.m_20334_(((double)toPos.m_123341_() - this.player.m_20185_()) * 0.25, ((double)toPos.m_123342_() - this.player.m_20186_()) * 0.25, ((double)toPos.m_123343_() - this.player.m_20189_()) * 0.25);
            CSEffectEntity.createInstance((LivingEntity)this.player, (Entity)target, (CSVisualType)CSVisualTypes.AQUAFLORA_ASSASSINATE.get(), 0.0, -0.2, 0.0);
            this.player.m_5496_((SoundEvent)CSSoundEvents.WIND_STRIKE.get(), 0.15f, 0.5f);
            float dualWieldMultiplier = this.checkDualWield(this.player, AquafloraItem.class) ? 0.8f : 1.0f;
            this.attributeDependentAttack((LivingEntity)this.player, target, this.stack, dualWieldMultiplier, AttackHurtTypes.RAPID_NO_KB);
            AquafloraSlashFrenzyAttack.createAquafloraFirework(this.getStack(), this.level, this.player, target.m_20185_(), target.m_20186_() + 1.0, target.m_20189_());
        }
    }

    @Override
    public void stopUsing() {
        this.getTagController().m_128379_(ATTACK_ONGOING, false);
        this.player.m_146926_(this.getTagController().m_128457_(INITIAL_VIEW_ANGLE));
        this.setCameraAngle(this.player, this.getTagController().m_128451_(INITIAL_PERSPECTIVE));
        if (!this.level.f_46443_) {
            ((ServerPlayer)this.player).f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket((Entity)this.player));
        } else {
            Minecraft.m_91087_().m_91118_((Entity)this.player);
        }
    }

    public static void createAquafloraFirework(ItemStack itemStack, Level level, Player player, double x, double y, double z) {
        ItemStack fireworkStarStack = new ItemStack((ItemLike)Items.f_42689_);
        CompoundTag starExplosionDataTag = fireworkStarStack.m_41698_("Explosion");
        ArrayList list = Lists.newArrayList();
        DyeColor[] allowedColors = new DyeColor[]{DyeColor.PINK, DyeColor.MAGENTA, DyeColor.WHITE};
        list.add(allowedColors[level.f_46441_.m_188503_(allowedColors.length)].m_41070_());
        starExplosionDataTag.m_128408_("Colors", (List)list);
        starExplosionDataTag.m_128344_("Type", (byte)FireworkRocketItem.Shape.SMALL_BALL.m_41236_());
        CompoundTag fireworkDataTag = itemStack.m_41698_("Fireworks");
        ListTag starDataListTag = new ListTag();
        CompoundTag explosionDataTag = fireworkStarStack.m_41737_("Explosion");
        if (explosionDataTag != null) {
            starDataListTag.add((Object)explosionDataTag);
        }
        fireworkDataTag.m_128344_("Flight", (byte)3);
        if (!starDataListTag.isEmpty()) {
            fireworkDataTag.m_128365_("Explosions", (Tag)starDataListTag);
        }
        level.m_7228_(x, y, z, 0.01, 0.01, 0.01, fireworkDataTag);
    }
}

