/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.common.attack.aquaflora;

import com.aqutheseal.celestisynth.api.animation.player.PlayerAnimationContainer;
import com.aqutheseal.celestisynth.api.item.AttackHurtTypes;
import com.aqutheseal.celestisynth.common.attack.aquaflora.AquafloraAttack;
import com.aqutheseal.celestisynth.common.entity.base.CSEffectEntity;
import com.aqutheseal.celestisynth.common.entity.helper.CSVisualType;
import com.aqutheseal.celestisynth.common.registry.CSPlayerAnimations;
import com.aqutheseal.celestisynth.common.registry.CSSoundEvents;
import com.aqutheseal.celestisynth.common.registry.CSVisualTypes;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class AquafloraFlowersAwayAttack
extends AquafloraAttack {
    public AquafloraFlowersAwayAttack(Player player, ItemStack stack, int heldDuration) {
        super(player, stack, heldDuration);
    }

    @Override
    public PlayerAnimationContainer getAnimation() {
        return (PlayerAnimationContainer)CSPlayerAnimations.ANIM_POLTERGEIST_RETREAT.get();
    }

    @Override
    public int getCooldown() {
        return 30;
    }

    @Override
    public int getAttackStopTime() {
        return 0;
    }

    @Override
    public boolean getCondition() {
        return this.getTagController().m_128471_("cs.checkPassiveIfBlooming") && this.player.m_6047_();
    }

    @Override
    public void startUsing() {
        this.sendExpandingParticles(this.level, (ParticleType<?>)ParticleTypes.f_123810_, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_(), 55, 1.2f);
        CSEffectEntity.createInstance((LivingEntity)this.player, null, (CSVisualType)CSVisualTypes.AQUAFLORA_FLOWER.get(), 0.0, -1.0, 0.0);
        List<Entity> entities = this.iterateEntities(this.level, this.createAABB((Vec3i)this.player.m_20183_(), 12.0));
        this.player.m_5496_((SoundEvent)CSSoundEvents.BLING.get(), 0.4f, 0.5f);
        for (Entity target : entities) {
            if (!(target instanceof LivingEntity)) continue;
            LivingEntity lt = (LivingEntity)target;
            if (target == this.player || !target.m_6084_() || this.player.m_7307_(target)) continue;
            CSEffectEntity.createInstance((LivingEntity)this.player, target, (CSVisualType)CSVisualTypes.AQUAFLORA_FLOWER_BIND.get());
            this.attributeDependentAttack((LivingEntity)this.player, lt, this.stack, 0.5f, AttackHurtTypes.NO_KB);
            target.m_20334_((this.player.m_20185_() - target.m_20185_()) * 0.35, (this.player.m_20186_() - target.m_20186_()) * 0.35, (this.player.m_20189_() - target.m_20189_()) * 0.35);
        }
    }

    @Override
    public void tickAttack() {
    }

    @Override
    public void stopUsing() {
        this.getTagController().m_128379_("cs.checkPassiveIfBlooming", false);
    }
}

