/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.client.renderers.misc.tooltips;

import com.aqutheseal.celestisynth.Celestisynth;
import com.aqutheseal.celestisynth.api.item.CSWeapon;
import com.aqutheseal.celestisynth.client.renderers.misc.tooltips.AbilityComponent;
import com.aqutheseal.celestisynth.common.block.StarlitFactoryBlockEntity;
import com.aqutheseal.celestisynth.common.registry.CSRarityTypes;
import com.aqutheseal.celestisynth.util.ExtraUtil;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class CSTooltipRenderer {
    public static final ResourceLocation TOOLTIP_EXTRAS = Celestisynth.prefix("textures/gui/tooltip_extras.png");
    @OnlyIn(value=Dist.CLIENT)
    public static int menu;
    @OnlyIn(value=Dist.CLIENT)
    public static int scroll;

    public static void manageCelestialTooltips(RenderTooltipEvent.GatherComponents event) {
        Item item;
        ItemStack stack = event.getItemStack();
        String name = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_();
        List elements = event.getTooltipElements();
        ArrayList<Either> elementsToAdd = new ArrayList<Either>();
        Style tierColor = Style.f_131099_.m_178520_(ExtraUtil.getCelestialColor(scroll * 4).argbInt());
        Style navigationNoticeColor = Style.f_131099_.m_178520_(9884672);
        if (!stack.m_41619_() && StarlitFactoryBlockEntity.getFuelMap().containsKey(stack.m_41720_())) {
            elementsToAdd.add(Either.left((Object)Component.m_237110_((String)"item.celestisynth.starlit_fuel_amount", (Object[])new Object[]{StarlitFactoryBlockEntity.getFuelMap().get(stack.m_41720_())}).m_130948_(tierColor).m_130948_(Style.f_131099_.m_178520_(4965839))));
        }
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof CSWeapon) {
            CSWeapon cs = (CSWeapon)item;
            MutableComponent empty = Component.m_237113_((String)" ");
            elementsToAdd.add(Either.left((Object)Component.m_237115_((String)"item.celestisynth.celestial_tier").m_130948_(tierColor)));
            elementsToAdd.add(Either.left((Object)Component.m_237115_((String)"item.celestisynth.shift_notice").m_130948_(navigationNoticeColor)));
            elementsToAdd.add(Either.left((Object)empty));
            elementsToAdd.add(Either.right((Object)new MenuData(menu % 2)));
            elementsToAdd.add(Either.left((Object)Component.m_237115_((String)"item.celestisynth.scroll_notice").m_130948_(navigationNoticeColor)));
            elementsToAdd.add(Either.left((Object)empty));
            if (menu % 2 == 0) {
                if (cs.getPassiveAmount() > 0) {
                    highlightedIndex = Math.abs(scroll % cs.getPassiveAmount());
                    elementsToAdd.add(Either.right((Object)new AbilityComponent.Data(name, cs.getPassiveAmount(), highlightedIndex + 1, AbilityComponent.Side.PASSIVE)));
                }
            } else if (menu % 2 == 1 && cs.getSkillsAmount() > 0) {
                highlightedIndex = Math.abs(scroll % cs.getSkillsAmount());
                elementsToAdd.add(Either.right((Object)new AbilityComponent.Data(name, cs.getSkillsAmount(), highlightedIndex + 1, AbilityComponent.Side.SKILL)));
            }
        }
        ListIterator iterator = elementsToAdd.listIterator(elementsToAdd.size());
        while (iterator.hasPrevious()) {
            elements.add(1, (Either)iterator.previous());
        }
    }

    public static void manageTooltipScrolling(double delta) {
        if (delta < 0.0) {
            int n = scroll = scroll + 1 == Integer.MAX_VALUE ? 0 : scroll + 1;
        }
        if (delta > 0.0) {
            scroll = scroll - 1 == 0 ? Integer.MAX_VALUE : scroll - 1;
        }
    }

    public static void manageKeyPress(double keyCode) {
        if (keyCode == 340.0 || keyCode == 341.0) {
            menu = menu + 1 == Integer.MAX_VALUE ? 0 : menu + 1;
        }
    }

    public static void manageTooltipColors(RenderTooltipEvent.Color event) {
        int argb = -16777216;
        if (event.getItemStack().m_41791_() == CSRarityTypes.CELESTIAL) {
            event.setBackgroundStart(argb + 2);
            event.setBackgroundEnd(argb + 63);
            event.setBorderStart(argb + 15382543);
            event.setBorderEnd(argb + 450225);
        }
    }

    public record MenuData(int tab) implements TooltipComponent
    {
    }

    public static class BorderRenderer
    implements ClientTooltipComponent {
        public int m_142103_() {
            return 16;
        }

        public int m_142069_(Font pFont) {
            return 320;
        }

        public void m_183452_(Font pFont, int pX, int pY, GuiGraphics pGuiGraphics) {
            int width = pGuiGraphics.m_280182_() / 16 / 3;
            int positionHeight = this.m_142103_() / 4;
            for (int i = 0; i < width; ++i) {
                if (i == 0) {
                    pGuiGraphics.m_280218_(TOOLTIP_EXTRAS, pX, pY + positionHeight, 0, 0, 16, 5);
                    continue;
                }
                if (i == width - 1) {
                    pGuiGraphics.m_280218_(TOOLTIP_EXTRAS, pX + i * 16, pY + positionHeight, 32, 0, 16, 5);
                    continue;
                }
                pGuiGraphics.m_280218_(TOOLTIP_EXTRAS, pX + i * 16, pY + positionHeight, 16, 0, 16, 5);
            }
        }
    }

    public record BorderData() implements TooltipComponent
    {
    }

    public record MenuRenderer(int tab) implements ClientTooltipComponent
    {
        public int m_142103_() {
            return 22;
        }

        public int m_142069_(Font pFont) {
            return 40;
        }

        public void m_183452_(Font pFont, int pX, int pY, GuiGraphics pGuiGraphics) {
            int moveToCenter = 0;
            int otherOffset = 60;
            if (this.tab == 0) {
                pGuiGraphics.m_280218_(TOOLTIP_EXTRAS, pX + moveToCenter, pY, 0, 5, 49, 10);
            } else {
                pGuiGraphics.m_280218_(TOOLTIP_EXTRAS, pX + moveToCenter, pY, 49, 5, 49, 10);
            }
            if (this.tab == 1) {
                pGuiGraphics.m_280218_(TOOLTIP_EXTRAS, pX + moveToCenter + otherOffset, pY, 0, 16, 41, 11);
            } else {
                pGuiGraphics.m_280218_(TOOLTIP_EXTRAS, pX + moveToCenter + otherOffset, pY, 41, 16, 41, 11);
            }
        }
    }
}

