/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.client.renderers.misc;

import com.aqutheseal.celestisynth.Celestisynth;
import com.aqutheseal.celestisynth.api.mixin.PlayerMixinSupport;
import com.aqutheseal.celestisynth.manager.CSConfigManager;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.event.RenderGuiEvent;
import org.joml.Matrix4f;
import software.bernie.geckolib.core.object.Color;

public class CSGuiRenderer {
    public RenderGuiEvent event;
    public GuiGraphics gui;
    public PoseStack pose;
    public Matrix4f poseMatrix;
    public MultiBufferSource.BufferSource buffer;
    public Font font;

    public CSGuiRenderer(RenderGuiEvent event) {
        this.event = event;
        this.gui = event.getGuiGraphics();
        this.pose = this.gui.m_280168_();
        this.poseMatrix = this.pose.m_85850_().m_252922_();
        this.buffer = this.gui.m_280091_();
        this.font = Minecraft.m_91087_().f_91062_;
    }

    public int getWidth() {
        return this.event.getWindow().m_85441_() / 2;
    }

    public int getHeight() {
        return this.event.getWindow().m_85442_() / 2;
    }

    public void renderGuiAdditions() {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer instanceof PlayerMixinSupport) {
            PlayerMixinSupport mixinPlayer = (PlayerMixinSupport)localPlayer;
            if (!Minecraft.m_91087_().m_91104_() && mixinPlayer.getPulseScale() > 0) {
                Color pulse = Color.ofRGBA((int)255, (int)255, (int)255, (int)Mth.m_14045_((int)mixinPlayer.getPulseScale(), (int)0, (int)255));
                this.gui.m_280509_(0, 0, this.getWidth(), this.getHeight(), pulse.argbInt());
            }
        }
    }

    public void renderGuiAdditionsPre() {
    }

    public void renderGuiAdditionsPost() {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer instanceof PlayerMixinSupport) {
            PlayerMixinSupport mixinPlayer = (PlayerMixinSupport)localPlayer;
            if (!Minecraft.m_91087_().m_91104_()) {
                if (mixinPlayer.getTexturePulseMark() < 20 && !mixinPlayer.getTexturePulseImage().isEmpty()) {
                    float lerp = Mth.m_14179_((float)((float)mixinPlayer.getTexturePulseMark() / 20.0f), (float)0.5f, (float)0.0f);
                    ResourceLocation location = Celestisynth.prefix("textures/misc/" + mixinPlayer.getTexturePulseImage() + ".png");
                    if (this.allowVignetteList().contains(mixinPlayer.getTexturePulseImage())) {
                        this.renderVignette(this.gui, this.getWidth(), this.getHeight(), lerp * 0.5f);
                    }
                    this.render256x256(location, this.gui, this.getWidth(), this.getHeight(), 1.0f, 0.0f, 0.1f, lerp);
                }
                int pointerX = this.getWidth() / 2;
                int pointerY = this.getHeight() / 2;
                if (((Boolean)CSConfigManager.CLIENT.showChantMessages.get()).booleanValue() && mixinPlayer.getChantMark() < 20 && !mixinPlayer.getChantMessage().isEmpty()) {
                    MutableComponent text = Component.m_237115_((String)mixinPlayer.getChantMessage());
                    int textLength = this.font.m_92724_(text.m_7532_());
                    int lerp = (int)Mth.m_14179_((float)((float)mixinPlayer.getChantMark() / 20.0f), (float)255.0f, (float)0.0f);
                    Color base = new Color(mixinPlayer.getChantColor());
                    Color pulse = Color.ofRGBA((int)base.getRed(), (int)base.getGreen(), (int)base.getBlue(), (int)Mth.m_14045_((int)lerp, (int)0, (int)255));
                    Color modifiedPulse = pulse.darker(5.0f);
                    float txt = (float)textLength / 2.0f;
                    float xOffset = -((float)this.getWidth() / 8.0f) * 1.3f;
                    float yOffset = -((float)this.getHeight() / 8.0f * 1.3f) + 7.5f;
                    this.font.m_168645_(text.m_7532_(), (float)pointerX + xOffset - txt, (float)pointerY + yOffset, pulse.argbInt(), modifiedPulse.argbInt(), this.poseMatrix.scale(1.5f), (MultiBufferSource)this.buffer, 0xF000F0);
                    this.poseMatrix.normal().scale(1.5f);
                }
            }
        }
    }

    public List<String> allowVignetteList() {
        ArrayList<String> whitelist = new ArrayList<String>();
        whitelist.add("keres_sacrifice_0");
        whitelist.add("keres_sacrifice_1");
        whitelist.add("keres_sacrifice_2");
        whitelist.add("keres_sacrifice_3");
        return whitelist;
    }

    public void render256x256(ResourceLocation texture, GuiGraphics gui, int width, int height, float red, float green, float blue, float alpha) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        gui.m_280246_(red, green, blue, alpha);
        gui.m_280398_(texture, 0, 0, -90, 0.0f, 0.0f, width, height, width, height);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.defaultBlendFunc();
    }

    public void renderVignette(GuiGraphics gui, int width, int height, float alpha) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        gui.m_280246_(1.0f, 1.0f, 1.0f, alpha);
        gui.m_280398_(new ResourceLocation("textures/misc/vignette.png"), 0, 0, -90, 0.0f, 0.0f, width, height, width, height);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.defaultBlendFunc();
    }
}

