/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.client.renderers.misc;

import com.aqutheseal.celestisynth.client.models.misc.CSEffectEntityModel;
import com.aqutheseal.celestisynth.client.renderers.entity.projectile.SilencedRotationProjectileRenderer;
import com.aqutheseal.celestisynth.common.entity.base.CSEffectEntity;
import com.aqutheseal.celestisynth.common.entity.helper.CSVisualSpecialProperties;
import com.aqutheseal.celestisynth.manager.CSConfigManager;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.object.Color;

public class CSEffectEntityRenderer
extends SilencedRotationProjectileRenderer<CSEffectEntity> {
    public CSEffectEntityRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new CSEffectEntityModel());
    }

    public void preRender(PoseStack poseStack, CSEffectEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float lerpBodyRot = Mth.m_14189_((float)partialTick, (float)animatable.f_19859_, (float)animatable.m_146908_()) - 165.0f;
        float ageInTicks = (float)animatable.f_19797_ + partialTick;
        this.applyRotations(animatable, poseStack, ageInTicks, lerpBodyRot, partialTick);
        if (animatable.getVisualType().isRotateRandomly() && !animatable.getVisualType().hasSpecialProperties()) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_((float)animatable.getRotationX()));
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)animatable.getRotationZ()));
        }
        CSVisualSpecialProperties.set(animatable, poseStack, partialTick, bufferSource, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderFinal(PoseStack poseStack, CSEffectEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.renderFinal(poseStack, (Entity)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        super.renderFinal(poseStack, (Entity)animatable, model, bufferSource, bufferSource.m_6299_(RenderType.m_234338_((ResourceLocation)this.m_5478_(animatable))), partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void scaleModelForRender(float widthScale, float heightScale, PoseStack poseStack, CSEffectEntity animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        float f = (float)animatable.getVisualType().getScale();
        super.scaleModelForRender(widthScale * f, heightScale * f, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    public RenderType getRenderType(CSEffectEntity animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.m_110454_((ResourceLocation)texture, (boolean)false);
    }

    protected int getBlockLightLevel(CSEffectEntity p_114496_, BlockPos p_114497_) {
        return 15;
    }

    protected int getSkyLightLevel(CSEffectEntity p_114509_, BlockPos p_114510_) {
        return 15;
    }

    public Color getRenderColor(CSEffectEntity animatable, float partialTick, int packedLight) {
        Minecraft mc = Minecraft.m_91087_();
        float decreasingAlpha = 1.0f;
        boolean shouldHideAtFirstPerson = false;
        if (animatable.getVisualType().isFadeOut()) {
            int lifespan = animatable.getVisualType().getAnimation().getLifespan();
            decreasingAlpha = 1.0f - (float)animatable.f_19797_ / (float)lifespan;
        }
        if (!((Boolean)CSConfigManager.CLIENT.visibilityOnFirstPerson.get()).booleanValue() && mc.f_91073_ != null && animatable.getOwnerUuid() != null && mc.f_91074_ != null && mc.f_91066_.m_92176_().m_90612_() && animatable.getOwnerUuid() == mc.f_91074_.m_20148_()) {
            shouldHideAtFirstPerson = true;
        }
        return Color.ofRGBA((float)1.0f, (float)1.0f, (float)1.0f, (float)(shouldHideAtFirstPerson ? 0.0f : decreasingAlpha));
    }
}

