/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.client.events;

import com.aqutheseal.celestisynth.api.item.CSWeapon;
import com.aqutheseal.celestisynth.api.mixin.PlayerMixinSupport;
import com.aqutheseal.celestisynth.client.renderers.entity.layer.FrostboundGeoLayer;
import com.aqutheseal.celestisynth.client.renderers.misc.CSGuiRenderer;
import com.aqutheseal.celestisynth.client.renderers.misc.tooltips.CSTooltipRenderer;
import com.aqutheseal.celestisynth.common.capabilities.CSEntityCapabilityProvider;
import com.aqutheseal.celestisynth.common.item.weapons.AquafloraItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import software.bernie.geckolib.event.GeoRenderEvent;

public class CSClientMiscEvents {
    @SubscribeEvent
    public static void onGeoEntityRender(GeoRenderEvent.Entity.CompileRenderLayers event) {
        event.addLayer(new FrostboundGeoLayer(event.getRenderer()));
    }

    @SubscribeEvent
    public static void onScreenRender(ScreenEvent.Opening event) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            ItemStack itemR = Minecraft.m_91087_().f_91074_.m_21205_();
            ItemStack itemL = Minecraft.m_91087_().f_91074_.m_21206_();
            if (itemR.m_41720_() instanceof CSWeapon && itemR.m_41737_("csController") != null && itemR.m_41737_("csController").m_128471_("cs.hasAnimationBegun")) {
                event.setCanceled(true);
            }
            if (itemL.m_41720_() instanceof CSWeapon && itemL.m_41737_("csController") != null && itemL.m_41737_("csController").m_128471_("cs.hasAnimationBegun")) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingRender(RenderLivingEvent event) {
        CSEntityCapabilityProvider.get(event.getEntity()).ifPresent(data -> {
            if (data.getTrueInvisibility() > 0) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public static void onTooltipColor(RenderTooltipEvent.Color event) {
        CSTooltipRenderer.manageTooltipColors(event);
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGuiEvent event) {
        new CSGuiRenderer(event).renderGuiAdditions();
    }

    @SubscribeEvent
    public static void onRenderGuiPre(RenderGuiEvent.Pre event) {
        new CSGuiRenderer((RenderGuiEvent)event).renderGuiAdditionsPre();
    }

    @SubscribeEvent
    public static void onRenderGuiPost(RenderGuiEvent.Post event) {
        new CSGuiRenderer((RenderGuiEvent)event).renderGuiAdditionsPost();
    }

    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        PlayerMixinSupport supportedPlayer = (PlayerMixinSupport)player;
        if (!mc.f_91066_.m_92176_().m_90612_()) {
            CSClientMiscEvents.checkAndSetAngle(event, player.m_21206_());
            CSClientMiscEvents.checkAndSetAngle(event, player.m_21205_());
        }
        float delta = Minecraft.m_91087_().m_91296_();
        float ticksExistedDelta = (float)player.f_19797_ + delta;
        float intensity = supportedPlayer.getScreenShakeIntensity();
        float duration = supportedPlayer.getScreenShakeDuration();
        if (duration > 0.0f && !Minecraft.m_91087_().m_91104_() && mc.f_91073_.m_5776_()) {
            event.setPitch((float)((double)event.getPitch() + (double)intensity * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0));
            event.setYaw((float)((double)event.getYaw() + (double)intensity * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0));
            event.setRoll((float)((double)event.getRoll() + (double)intensity * Math.cos(ticksExistedDelta * 4.0f) * 25.0));
        }
    }

    @SubscribeEvent
    public static void onCameraZoom(ViewportEvent.ComputeFov event) {
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.f_91066_.m_92176_().m_90612_()) {
            CSClientMiscEvents.checkAndSetFOV(event, mc.f_91074_.m_21206_());
            CSClientMiscEvents.checkAndSetFOV(event, mc.f_91074_.m_21205_());
        }
    }

    @SubscribeEvent
    public static void onToolTipComponent(RenderTooltipEvent.GatherComponents event) {
        CSTooltipRenderer.manageCelestialTooltips(event);
    }

    private static void checkAndSetAngle(ViewportEvent.ComputeCameraAngles event, ItemStack itemStack) {
        CompoundTag tagElement;
        if (itemStack.m_41720_() instanceof AquafloraItem && (tagElement = itemStack.m_41737_("csController")) != null && tagElement.m_128471_("cs.hasAnimationBegun") && tagElement.m_128471_("cs.atkOngoing")) {
            event.setPitch(90.0f);
        }
    }

    private static void checkAndSetFOV(ViewportEvent.ComputeFov event, ItemStack itemStack) {
        Item item;
        CompoundTag tagElement = itemStack.m_41737_("csController");
        if (tagElement != null && (item = itemStack.m_41720_()) instanceof AquafloraItem) {
            AquafloraItem aquafloraItem = (AquafloraItem)item;
        }
    }
}

