/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.api.skill;

import com.aqutheseal.celestisynth.api.skill.ISkillInstance;
import com.aqutheseal.celestisynth.common.attack.base.WeaponAttackInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public abstract class BaseSkillInstance
implements ISkillInstance {
    protected Component skillName;
    protected Component skillDescription;
    protected final Component skillCriterionDescription;
    protected ResourceLocation skillIcon;
    protected final int minSkillLevel;
    protected final int maxSkillLevel;
    protected final int skillCooldown;

    public BaseSkillInstance(Component skillName, Component skillDescription, Component skillCriterionDescription, ResourceLocation skillIcon, int minSkillLevel, int maxSkillLevel, int skillCooldown) {
        this.skillName = skillName;
        this.skillDescription = skillDescription;
        this.skillCriterionDescription = skillCriterionDescription;
        this.skillIcon = skillIcon;
        this.minSkillLevel = minSkillLevel;
        this.maxSkillLevel = maxSkillLevel;
        this.skillCooldown = skillCooldown;
    }

    @Override
    public Component getName() {
        return this.skillName;
    }

    @Override
    public Component getDescription() {
        return this.skillDescription;
    }

    @Override
    public Component getCriterionDescription() {
        return this.skillCriterionDescription;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.skillIcon;
    }

    @Override
    @Nullable
    public abstract WeaponAttackInstance getAttack();

    @Override
    public int getMinSkillLevel() {
        return this.minSkillLevel;
    }

    @Override
    public int getMaxSkillLevel() {
        return this.maxSkillLevel;
    }

    @Override
    public int getSkillCooldown() {
        return this.skillCooldown;
    }

    @Override
    public abstract boolean isPassive();

    @Override
    public abstract boolean getActivationConditions(Player var1);

    @Override
    public abstract boolean getDeactivationConditions(Player var1);

    @Override
    public abstract void onSkillLearned(Player var1);

    @Override
    public abstract void onSkillUnlearned(Player var1);

    @Override
    public abstract void onSkillLevelChanged(Player var1, boolean var2);

    @Override
    public abstract void onSkillActivated(Player var1);

    @Override
    public abstract void onSkillTick(Player var1);

    @Override
    public abstract void onPassiveTick(Player var1);

    @Override
    public abstract void onSkillDeactivated(Player var1);

    @Override
    public abstract void setSkillLevel(int var1);

    @Override
    public abstract void setAttack(@Nullable WeaponAttackInstance var1, boolean var2);

    @Override
    public void setName(Component newName) {
        this.skillName = newName;
    }

    @Override
    public void setDescription(Component newDescription) {
        this.skillDescription = newDescription;
    }

    @Override
    public void setIcon(ResourceLocation skillIcon) {
        this.skillIcon = skillIcon;
    }
}

