/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.api.item;

import com.aqutheseal.celestisynth.api.animation.player.AnimationManager;
import com.aqutheseal.celestisynth.api.animation.player.PlayerAnimationContainer;
import com.aqutheseal.celestisynth.api.item.AttackHurtTypes;
import com.aqutheseal.celestisynth.api.item.CSWeapon;
import com.aqutheseal.celestisynth.api.mixin.PlayerMixinSupport;
import com.aqutheseal.celestisynth.common.network.c2s.ShakeScreenForAllPacket;
import com.aqutheseal.celestisynth.common.network.s2c.ChangeCameraTypePacket;
import com.aqutheseal.celestisynth.common.registry.CSAttributes;
import com.aqutheseal.celestisynth.common.registry.CSDamageSources;
import com.aqutheseal.celestisynth.common.registry.CSPlayerAnimations;
import com.aqutheseal.celestisynth.manager.CSNetworkManager;
import com.aqutheseal.celestisynth.util.ParticleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public interface CSWeaponUtil {
    public static final String CS_CONTROLLER_TAG_ELEMENT = "csController";
    public static final String CS_EXTRAS_ELEMENT = "csExtras";
    public static final String ANIMATION_TIMER_KEY = "cs.animationTimer";
    public static final String ANIMATION_BEGUN_KEY = "cs.hasAnimationBegun";

    default public float calculateAttributeDependentDamage(LivingEntity holder, ItemStack stack, float attackAttributeMultiplier) {
        float holderAttribute = (float)holder.m_21133_(Attributes.f_22281_) + EnchantmentHelper.m_44833_((ItemStack)holder.m_21205_(), (MobType)MobType.f_21640_);
        float holderAttackDamage = (holderAttribute - this.getDamageOfItem(holder.m_21205_()) + this.getDamageOfItem(stack)) * attackAttributeMultiplier;
        System.out.println("Base Attribute: " + holderAttribute);
        System.out.println("Attack Damage of Mainhand: " + this.getDamageOfItem(holder.m_21205_()));
        System.out.println("Attack Damage of Target Stack: " + this.getDamageOfItem(stack));
        System.out.println("Attack Damage of Overall Calculated Damage: " + holderAttackDamage);
        return holderAttackDamage;
    }

    default public void attributeDependentAttack(LivingEntity holder, LivingEntity target, ItemStack stack, float attackAttributeMultiplier, AttackHurtTypes attackHurtType) {
        this.initiateAbilityAttack(holder, target, this.calculateAttributeDependentDamage(holder, stack, attackAttributeMultiplier), attackHurtType);
    }

    private float getDamageOfItem(ItemStack stack) {
        return (float)(stack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).stream().mapToDouble(AttributeModifier::m_22218_).sum() + (double)EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_));
    }

    default public void initiateAbilityAttack(LivingEntity holder, LivingEntity target, float damage, DamageSource damageSource, AttackHurtTypes attackHurtType) {
        DamageSource finalDamageSource;
        if (damage == 0.0f) {
            return;
        }
        CSDamageSources source = new CSDamageSources(target.m_9236_().m_9598_());
        DamageSource regularDamage = source.basicPlayerAttack(holder);
        DamageSource rapidDamage = source.rapidPlayerAttack(holder);
        DamageSource regularDamageNoKB = source.basicPlayerAttackWithoutKB(holder);
        DamageSource rapidDamageNoKB = source.rapidPlayerAttackWithoutKB(holder);
        if (damageSource != null) {
            finalDamageSource = damageSource;
        } else {
            finalDamageSource = switch (attackHurtType) {
                default -> throw new IncompatibleClassChangeError();
                case AttackHurtTypes.REGULAR -> regularDamage;
                case AttackHurtTypes.NO_KB -> regularDamageNoKB;
                case AttackHurtTypes.RAPID -> rapidDamage;
                case AttackHurtTypes.RAPID_NO_KB -> rapidDamageNoKB;
            };
        }
        double finalDamage = (double)damage * holder.m_21133_((Attribute)CSAttributes.CELESTIAL_DAMAGE.get()) / target.m_21133_((Attribute)CSAttributes.CELESTIAL_DAMAGE_REDUCTION.get());
        if (!attackHurtType.doKnockback()) {
            double preAttribute = target.m_21051_(Attributes.f_22278_).m_22135_();
            target.m_21051_(Attributes.f_22278_).m_22100_(1000.0);
            this.attack(holder, target, (float)finalDamage, finalDamageSource, attackHurtType);
            target.m_21051_(Attributes.f_22278_).m_22100_(preAttribute);
        } else {
            this.attack(holder, target, (float)finalDamage, finalDamageSource, attackHurtType);
        }
    }

    default public void initiateAbilityAttack(LivingEntity holder, LivingEntity target, float damage, AttackHurtTypes attackHurtType) {
        this.initiateAbilityAttack(holder, target, damage, null, attackHurtType);
    }

    private void attack(LivingEntity holder, LivingEntity target, float damage, DamageSource damageSource, AttackHurtTypes attackHurtType) {
        if (attackHurtType.isRapid()) {
            target.f_19802_ = 0;
        }
        target.m_6469_(damageSource, damage);
    }

    default public CompoundTag attackController(ItemStack stack) {
        return stack.m_41698_(CS_CONTROLLER_TAG_ELEMENT);
    }

    default public CompoundTag attackExtras(ItemStack stack) {
        return stack.m_41698_(CS_EXTRAS_ELEMENT);
    }

    public static MobEffectInstance nonVisiblePotionEffect(MobEffect effect, int ticks, int amplifier) {
        return new MobEffectInstance(effect, ticks, amplifier, true, false, false);
    }

    default public void setDeltaPlayer(Player player, double x, double y, double z) {
        player.f_19864_ = true;
        player.m_20334_(x, y, z);
    }

    default public void setDeltaPlayer(Player player, Vec3 vec) {
        player.f_19864_ = true;
        player.m_20256_(vec);
    }

    default public float getSharpnessValue(ItemStack stack, float multiplier) {
        return (float)EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44977_, (ItemStack)stack) * multiplier;
    }

    default public void useAndDamageItem(ItemStack pStack, Level pLevel, LivingEntity targetOwnerEntity, int damageAmount) {
        if (!pLevel.f_46443_) {
            pStack.m_41622_(damageAmount, targetOwnerEntity, ownerEntity -> {
                if (targetOwnerEntity.m_21205_() == pStack) {
                    ownerEntity.m_21190_(InteractionHand.MAIN_HAND);
                } else if (targetOwnerEntity.m_21206_() == pStack) {
                    ownerEntity.m_21190_(InteractionHand.OFF_HAND);
                }
            });
        }
        if (targetOwnerEntity instanceof Player) {
            Player ownerPlayer = (Player)targetOwnerEntity;
            ownerPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)pStack.m_41720_()));
        }
    }

    default public void sendExpandingParticles(Level level, ParticleType<?> particleType, double x, double y, double z, int amount, float expansionMultiplier) {
        for (int i = 0; i < amount; ++i) {
            RandomSource random = level.m_213780_();
            float offX = (float)(random.m_188583_() * (double)expansionMultiplier);
            float offY = (float)(random.m_188583_() * (double)expansionMultiplier);
            float offZ = (float)(random.m_188583_() * (double)expansionMultiplier);
            ParticleUtil.sendParticles(level, particleType, x, y, z, 0, (double)offX, (double)offY, (double)offZ);
        }
    }

    default public void sendExpandingParticles(Level level, ParticleType<?> particleType, BlockPos origin, int amount, float expansionMultiplier) {
        this.sendExpandingParticles(level, particleType, origin.m_123341_(), origin.m_123342_(), origin.m_123343_(), amount, expansionMultiplier);
    }

    default public AABB createAABB(Vec3i pos, double range) {
        return this.createAABB(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), range);
    }

    default public AABB createAABB(Vec3i pos, double xzRange, double yRange) {
        return this.createAABB(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), xzRange, yRange);
    }

    default public AABB createAABB(double x, double y, double z, double range) {
        return this.createAABB(x, y, z, range, range);
    }

    default public AABB createAABB(double x, double y, double z, double xzRange, double yRange) {
        return new AABB(x + xzRange, y + yRange, z + xzRange, x - xzRange, y - yRange, z - xzRange);
    }

    default public List<Entity> iterateEntities(Level level, AABB aabb) {
        return level.m_45976_(Entity.class, aabb);
    }

    default public boolean checkDualWield(Player player, Class<? extends CSWeapon> weapon) {
        return weapon.isInstance(player.m_21205_().m_41720_()) && weapon.isInstance(player.m_21206_().m_41720_());
    }

    default public void shakeScreensForNearbyPlayers(Entity holder, Level level, double range, int maxDuration, int startFadingOut, float maxIntensity) {
        if (level.m_5776_()) {
            List entities = level.m_45976_(Player.class, holder.m_20191_().m_82377_(range, range, range));
            for (Player entity : entities) {
                this.shakeScreens(entity, maxDuration, startFadingOut, Math.max(0.0f, maxIntensity - (float)(entity.m_20280_(holder) * 1.0E-5)));
            }
        }
    }

    default public void shakeScreens(Player target, int duration, int startFadingOut, float intensity) {
        if (target != null) {
            CSNetworkManager.sendToServer(new ShakeScreenForAllPacket(target.m_20148_(), duration, startFadingOut, intensity));
        }
    }

    default public double calculateXLook(LivingEntity player) {
        return player.m_20154_().m_7096_();
    }

    default public double calculateYLook(LivingEntity player, double yMult) {
        double lookY = player.m_20154_().m_7098_();
        if (lookY > 0.0) {
            return lookY * yMult;
        }
        return lookY * 0.5;
    }

    default public double calculateYLook(LivingEntity player) {
        return player.m_20154_().m_7098_();
    }

    default public double calculateZLook(LivingEntity player) {
        return player.m_20154_().m_7094_();
    }

    default public void setCameraAngle(Player player, int ordinal) {
        if (!player.m_9236_().m_5776_()) {
            CSNetworkManager.sendToAll(new ChangeCameraTypePacket(player.m_19879_(), ordinal));
        }
    }

    public static void disableRunningWeapon(Entity owner) {
        if (owner instanceof Player) {
            Player playerOwner = (Player)owner;
            AnimationManager.playAnimation(owner.m_9236_(), (PlayerAnimationContainer)CSPlayerAnimations.CLEAR.get());
            AnimationManager.playAnimation(owner.m_9236_(), (PlayerAnimationContainer)CSPlayerAnimations.CLEAR.get(), 2);
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                Item item = playerOwner.m_6844_(slot).m_41720_();
                if (!(item instanceof CSWeapon)) continue;
                CSWeapon cs = (CSWeapon)item;
                CompoundTag data = playerOwner.m_6844_(slot).m_41737_(CS_CONTROLLER_TAG_ELEMENT);
                CompoundTag dataAlt = playerOwner.m_6844_(slot).m_41737_(CS_EXTRAS_ELEMENT);
                if (data != null) {
                    data.m_128431_().clear();
                }
                if (dataAlt != null) {
                    dataAlt.m_128431_().clear();
                }
                cs.resetExtraValues(playerOwner.m_6844_(slot), playerOwner);
            }
            if (playerOwner.m_6117_()) {
                playerOwner.m_21253_();
            }
        }
    }

    default public BlockPos getFloorPositionUnderPlayer(Level level, BlockPos pos) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        do {
            mutablePos.m_122173_(Direction.DOWN);
        } while (mutablePos.m_123342_() > level.m_141937_() && level.m_8055_((BlockPos)mutablePos).m_60647_((BlockGetter)level, (BlockPos)mutablePos, PathComputationType.LAND));
        return new BlockPos(mutablePos.m_123341_(), mutablePos.m_123342_(), mutablePos.m_123343_());
    }

    default public int getFloorPositionUnderPlayerYLevel(Level level, BlockPos pos) {
        return this.getFloorPositionUnderPlayer(level, pos).m_123342_();
    }

    default public List<LivingEntity> getEntitiesInLine(Player player, double maxDistance) {
        Vec3 originPosition = player.m_146892_();
        Vec3 lookDirection = player.m_20154_().m_82541_().m_82542_(1.0, 0.0, 1.0);
        Vec3 endPosition = originPosition.m_82549_(lookDirection.m_82490_(maxDistance));
        AABB rangeBox = new AABB(originPosition, endPosition);
        List possibleEntitiesInRange = player.m_9236_().m_6249_((Entity)player, rangeBox, entity -> entity instanceof LivingEntity);
        ArrayList<LivingEntity> livingEntitiesInLine = new ArrayList<LivingEntity>();
        for (Entity entity2 : possibleEntitiesInRange) {
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity2;
            AABB entityBox = entity2.m_20191_().m_82377_(0.5, 0.5, 0.5);
            Optional optionalIntersection = entityBox.m_82371_(originPosition, endPosition);
            if (!optionalIntersection.isPresent()) continue;
            livingEntitiesInLine.add(living);
        }
        return livingEntitiesInLine;
    }

    default public Entity getLookedAtEntity(LivingEntity holder, double range) {
        AABB aabb;
        double distance = range * range;
        Vec3 eyePos = holder.m_20299_(1.0f);
        Vec3 viewVec = holder.m_20252_(1.0f);
        Vec3 targetVec = eyePos.m_82520_(viewVec.f_82479_ * range, viewVec.f_82480_ * range, viewVec.f_82481_ * range);
        EntityHitResult hitResult = CSWeaponUtil.expandedHitResult((Entity)holder, eyePos, targetVec, aabb = holder.m_20191_().m_82369_(viewVec.m_82490_(range)).m_82377_(4.0, 4.0, 4.0), entity -> !entity.m_5833_(), distance);
        return hitResult != null ? hitResult.m_82443_() : null;
    }

    @Nullable
    public static EntityHitResult expandedHitResult(Entity pShooter, Vec3 pStartVec, Vec3 pEndVec, AABB pBoundingBox, Predicate<Entity> pFilter, double pDistance) {
        Level level = pShooter.m_9236_();
        double range = pDistance;
        Entity confirmedTarget = null;
        Vec3 clipVec = null;
        for (Entity potentialTarget : level.m_6249_(pShooter, pBoundingBox, pFilter)) {
            Vec3 vec31;
            double distToTargetPos;
            AABB boundsHitbox = potentialTarget.m_20191_().m_82400_((double)potentialTarget.m_6143_() + 2.5);
            Optional potentialClippedVec = boundsHitbox.m_82371_(pStartVec, pEndVec);
            if (boundsHitbox.m_82390_(pStartVec)) {
                if (!(range >= 0.0)) continue;
                confirmedTarget = potentialTarget;
                clipVec = potentialClippedVec.orElse(pStartVec);
                range = 0.0;
                continue;
            }
            if (!potentialClippedVec.isPresent() || !((distToTargetPos = pStartVec.m_82557_(vec31 = (Vec3)potentialClippedVec.get())) < range) && range != 0.0) continue;
            if (potentialTarget.m_20201_() == pShooter.m_20201_() && !potentialTarget.canRiderInteract()) {
                if (range != 0.0) continue;
                confirmedTarget = potentialTarget;
                clipVec = vec31;
                continue;
            }
            confirmedTarget = potentialTarget;
            clipVec = vec31;
            range = distToTargetPos;
        }
        return confirmedTarget == null ? null : new EntityHitResult(confirmedTarget, clipVec);
    }

    default public void playSoundAt(Level level, SoundEvent sound, BlockPos pos) {
        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), sound, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    default public void chantMessage(Entity player, String id, int time, int color) {
        if (player instanceof PlayerMixinSupport) {
            PlayerMixinSupport mixinPlayer = (PlayerMixinSupport)player;
            if (player.m_9236_().f_46443_) {
                mixinPlayer.setChantMark(-time);
                mixinPlayer.setChantColor(color);
                mixinPlayer.setChantMessage("chant.celestisynth." + id);
            }
        }
    }

    default public void flashScreen(Entity player, int pulseScale, int speed) {
        if (player instanceof PlayerMixinSupport) {
            PlayerMixinSupport mixinPlayer = (PlayerMixinSupport)player;
            if (player.m_9236_().f_46443_) {
                mixinPlayer.setPulseScale(pulseScale);
                mixinPlayer.setPulseTimeSpeed(speed);
            }
        }
    }

    default public void pulseImageOnUI(Entity player, String textureName, int time) {
        if (player instanceof PlayerMixinSupport) {
            PlayerMixinSupport mixinPlayer = (PlayerMixinSupport)player;
            if (player.m_9236_().f_46443_) {
                mixinPlayer.setTexturePulseMark(time);
                mixinPlayer.setTexturePulseImage(textureName);
            }
        }
    }
}

