/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.api.item;

import com.aqutheseal.celestisynth.api.animation.player.AnimationManager;
import com.aqutheseal.celestisynth.api.animation.player.PlayerAnimationContainer;
import com.aqutheseal.celestisynth.api.item.CSWeaponUtil;
import com.aqutheseal.celestisynth.common.attack.base.WeaponAttackInstance;
import com.google.common.collect.ImmutableList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public interface CSWeapon
extends CSWeaponUtil {
    public int getSkillsAmount();

    default public int getPassiveAmount() {
        return 0;
    }

    default public boolean hasPassive() {
        return false;
    }

    default public void onPlayerHurt(LivingHurtEvent event, ItemStack stack) {
    }

    default public void resetExtraValues(ItemStack stack, Player player) {
    }

    public ImmutableList<WeaponAttackInstance> getPossibleAttacks(Player var1, ItemStack var2, int var3);

    default public void executeAnimation(Level level, PlayerAnimationContainer animation, WeaponAttackInstance attack, InteractionHand hand) {
        if (attack.sameAnimationForBothHands()) {
            if (hand == InteractionHand.OFF_HAND) {
                AnimationManager.playAnimation(level, animation, 2);
            } else {
                AnimationManager.playAnimation(level, animation);
            }
        } else {
            AnimationManager.playAnimation(level, animation);
        }
    }
}

