/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.api.animation.player;

import com.aqutheseal.celestisynth.common.item.weapons.RainfallSerenityItem;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AdjustmentModifier;
import dev.kosmx.playerAnim.api.layered.modifier.MirrorModifier;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class CSAnimator {
    public static final Map<AbstractClientPlayer, ModifierLayer<IAnimation>> animationData = new IdentityHashMap<AbstractClientPlayer, ModifierLayer<IAnimation>>();
    public static final Map<AbstractClientPlayer, ModifierLayer<IAnimation>> otherAnimationData = new IdentityHashMap<AbstractClientPlayer, ModifierLayer<IAnimation>>();
    public static final Map<AbstractClientPlayer, ModifierLayer<IAnimation>> mirroredAnimationData = new IdentityHashMap<AbstractClientPlayer, ModifierLayer<IAnimation>>();

    public static void registerAnimationLayer(FMLClientSetupEvent event) {
        PlayerAnimationAccess.REGISTER_ANIMATION_EVENT.register(CSAnimator::registerPlayerAnimation);
    }

    public static void registerPlayerAnimation(AbstractClientPlayer player, AnimationStack stack) {
        ModifierLayer layer = new ModifierLayer();
        layer.addModifier((AbstractModifier)new AdjustmentModifier(partName -> {
            float zMod;
            float yMod;
            float xMod;
            float zRotMod;
            float yRotMod;
            float xRotMod;
            block25: {
                float rSplit0;
                block26: {
                    xRotMod = 0.0f;
                    yRotMod = 0.0f;
                    zRotMod = 0.0f;
                    xMod = 0.0f;
                    yMod = 0.0f;
                    zMod = 0.0f;
                    if (!(player.m_21211_().m_41720_() instanceof RainfallSerenityItem)) break block25;
                    boolean checkHand = player.m_7655_() == InteractionHand.MAIN_HAND;
                    float f0 = (float)Math.toRadians(player.m_146909_()) * 1.75f;
                    float f1 = (float)Math.toRadians(player.m_146909_()) * 9.0f;
                    rSplit0 = CSAnimator.rotationSplit(player.m_146909_(), f0, f1);
                    if (!checkHand) break block26;
                    switch (partName) {
                        case "leftArm": {
                            xRotMod = (float)Math.toRadians(player.m_146909_()) / 6.0f;
                            if (FirstPersonMode.isFirstPersonPass()) {
                                xMod = rSplit0;
                                break;
                            }
                            break block25;
                        }
                        case "rightArm": {
                            zRotMod = (float)(-Math.toRadians(player.m_146909_()));
                            if (FirstPersonMode.isFirstPersonPass()) {
                                xMod = rSplit0;
                                break;
                            }
                            break block25;
                        }
                        case "head": {
                            xRotMod = (float)Math.toRadians(player.m_146909_());
                            break;
                        }
                        default: {
                            return Optional.empty();
                        }
                    }
                    break block25;
                }
                switch (partName) {
                    case "rightArm": {
                        xRotMod = (float)(-Math.toRadians(player.m_146909_())) / 6.0f;
                        if (!FirstPersonMode.isFirstPersonPass()) break;
                        xMod = -rSplit0;
                        break;
                    }
                    case "leftArm": {
                        zRotMod = (float)Math.toRadians(player.m_146909_());
                        if (!FirstPersonMode.isFirstPersonPass()) break;
                        xMod = -rSplit0;
                        break;
                    }
                    case "head": {
                        xRotMod = (float)Math.toRadians(player.m_146909_());
                        break;
                    }
                    default: {
                        return Optional.empty();
                    }
                }
            }
            if (player.m_6047_()) {
                if (partName.equals("rightArm") || partName.equals("leftArm")) {
                    yMod += 3.0f;
                }
                if (partName.equals("head")) {
                    yMod += 3.0f;
                }
            }
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(xRotMod, yRotMod, zRotMod), new Vec3f(xMod, yMod, zMod)));
        }), 0);
        stack.addAnimLayer(6900, (IAnimation)layer);
        animationData.put(player, (ModifierLayer<IAnimation>)layer);
        ModifierLayer layerOther = new ModifierLayer();
        stack.addAnimLayer(1, (IAnimation)layerOther);
        otherAnimationData.put(player, (ModifierLayer<IAnimation>)layerOther);
        ModifierLayer layerMirrored = new ModifierLayer();
        layerMirrored.addModifier((AbstractModifier)new MirrorModifier(), 0);
        layer.addModifier((AbstractModifier)new AdjustmentModifier(partName -> {
            float xRotMod = 0.0f;
            float yRotMod = 0.0f;
            float zRotMod = 0.0f;
            float xMod = 0.0f;
            float yMod = 0.0f;
            float zMod = 0.0f;
            if (player.m_6047_()) {
                if (partName.equals("rightArm") || partName.equals("leftArm")) {
                    yMod -= 3.0f;
                }
                if (partName.equals("head")) {
                    yMod -= 3.0f;
                }
            }
            return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(xRotMod, yRotMod, zRotMod), new Vec3f(xMod, yMod, zMod)));
        }), 1);
        stack.addAnimLayer(6899, (IAnimation)layerMirrored);
        mirroredAnimationData.put(player, (ModifierLayer<IAnimation>)layerMirrored);
    }

    public static float rotationSplit(float faceRotation, float faceUpValue, float faceDownValue) {
        if (faceRotation < 0.0f) {
            return faceUpValue;
        }
        if (faceRotation > 0.0f) {
            return faceDownValue;
        }
        return 0.0f;
    }
}

