/*
 * Decompiled with CFR 0.152.
 */
package com.aqutheseal.celestisynth.api.animation.player;

import com.aqutheseal.celestisynth.api.animation.player.CSAnimator;
import com.aqutheseal.celestisynth.api.animation.player.PlayerAnimationContainer;
import com.aqutheseal.celestisynth.common.network.s2c.SetAnimationPacket;
import com.aqutheseal.celestisynth.manager.CSConfigManager;
import com.aqutheseal.celestisynth.manager.CSNetworkManager;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import javax.annotation.Nullable;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;

public class AnimationManager {
    public static void playAnimation(Level level, PlayerAnimationContainer animation) {
        AnimationManager.playAnimation(level, animation, 0);
    }

    public static void playAnimation(Level level, PlayerAnimationContainer animation, int layerIndex) {
        if (level.m_5776_()) {
            AnimationManager.playAnimation(animation, layerIndex);
        }
    }

    public static void playAnimation(PlayerAnimationContainer animation, int layerIndex) {
        CSNetworkManager.sendToServer(new SetAnimationPacket(layerIndex, animation.animationId()));
    }

    public static void playAnimation(@Nullable KeyframeAnimation animation, ModifierLayer<IAnimation> layer) {
        boolean isFirstPersonModelLoaded = ModList.get().isLoaded("firstpersonmod");
        if (animation == null) {
            layer.setAnimation(null);
        } else if (CSAnimator.animationData.containsValue(layer) || CSAnimator.otherAnimationData.containsValue(layer) || CSAnimator.mirroredAnimationData.containsValue(layer)) {
            layer.setAnimation((IAnimation)new KeyframeAnimationPlayer(animation).setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL).setFirstPersonConfiguration(new FirstPersonConfiguration().setShowRightArm(!isFirstPersonModelLoaded && (Boolean)CSConfigManager.CLIENT.showRightArmOnAnimate.get() != false).setShowRightItem(!isFirstPersonModelLoaded).setShowLeftArm(!isFirstPersonModelLoaded && (Boolean)CSConfigManager.CLIENT.showLeftArmOnAnimate.get() != false).setShowLeftItem(!isFirstPersonModelLoaded)));
        }
    }
}

