/*
 * Decompiled with CFR 0.152.
 */
package Shadow.relocated.capabilitysyncer.network;

import Shadow.relocated.capabilitysyncer.core.ISyncableCapability;
import Shadow.relocated.capabilitysyncer.network.ClientPacketHandler;
import Shadow.relocated.capabilitysyncer.network.EntityCapabilityStatusPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class SimpleEntityCapabilityStatusPacket
extends EntityCapabilityStatusPacket {
    private static final Map<ResourceLocation, Function<? extends Entity, ISyncableCapability>> capRetrievers = new HashMap<ResourceLocation, Function<? extends Entity, ISyncableCapability>>();
    private final ResourceLocation capabilityId;

    public SimpleEntityCapabilityStatusPacket(int entityId, ResourceLocation capabilityId, CompoundTag tag) {
        super(entityId, tag);
        this.capabilityId = capabilityId;
    }

    public SimpleEntityCapabilityStatusPacket(int entityId, ResourceLocation capabilityId, ISyncableCapability capability) {
        super(entityId, capability);
        this.capabilityId = capabilityId;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        super.write(buf);
        buf.m_130085_(this.capabilityId);
    }

    @Deprecated(since="3.0.2", forRemoval=true)
    public static <T extends Entity> void register(ResourceLocation capabilityId, Function<T, ISyncableCapability> capabilityRetriever, SimpleChannel channel, int id) {
        SimpleEntityCapabilityStatusPacket.registerRetriever(capabilityId, capabilityRetriever);
        SimpleEntityCapabilityStatusPacket.register(channel, id);
    }

    public static void register(SimpleChannel channel, int id) {
        SimpleEntityCapabilityStatusPacket.register(channel, id, SimpleEntityCapabilityStatusPacket.class, buf -> SimpleEntityCapabilityStatusPacket.read(buf, (entityId, tag) -> new SimpleEntityCapabilityStatusPacket((int)entityId, buf.m_130281_(), (CompoundTag)tag)));
    }

    public static <T extends Entity> void registerRetriever(ResourceLocation capabilityId, Function<T, ISyncableCapability> capabilityRetriever) {
        capRetrievers.put(capabilityId, capabilityRetriever);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> ClientPacketHandler.handleEntityCapabilityStatus(this, capRetrievers.get(this.capabilityId)));
    }
}

